//
//  WCTRestClientController+Batch.m
//
//
//  Created by Howard on 2017/4/7.
//
//

#import "WCTRestClientController+Batch.h"

// Category
#import "WCTRestClientController+Common.h"
#import "WCTRestClientController+LocalMode.h"

static CGFloat const WCTRestClientControllerMaxContactGuidPerRequest = 100.0;      // 用float是為了計算時可以無條件捨去小數點

@implementation WCTRestClientController (Batch)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Batch Method

//================================================================================
// 因為server一次處理太多筆會timeout, 所以另外實作分段處理的API, 不直接使用這個
//================================================================================
- (WCTRCPrivateContactOperateCategoryResponseResult *)_batchPrivateContactOperateCategoryWithContactSetCategoriesRequest:(WCTRCContactSetCategoriesRequest *)contactSetCategoriesRequest
                                                                                                                   error:(NSError **)error
{
    NSDate *startTime = [NSDate date];
    
    __block NSError *blockError = nil;
    __block WCTRCPrivateContactOperateCategoryResponseResult  *blockPrivateContactOperateCategoryResponseResult = nil;
    
    //////////////////////////////////////////////////
    
    if([self localModel]==NO)
    {
        do
        {
            WCTRestClient *restClient = [WCTRestClientController curRestClient];
            
            if(restClient==nil)
            {
                blockError = WCTRestClientErrorMake(@"網路傳輸架構 RestClient 不存在",blockError);
                break;
            }
            //////////////////////////////////////////////////
            
            //檢查連線狀態是否更新
            if([self checkTimeExpiredAndKeepConnectionWithError:&blockError]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_group_t group = dispatch_group_create();
            
            if(group==NULL)
            {
                blockError = WCTRestClientErrorMake(@"dispatch_group_create 失敗",blockError);
                break;
            }
            
            dispatch_group_enter(group);
            
            //////////////////////////////////////////////////
            
            RKObjectRequestOperation *requestOperation =  [restClient privateContactOperateCategoryWithLoginToken:[WCTRestClientController curLoginToken]
                                                                                      contactSetCategoriesRequest:contactSetCategoriesRequest
                                                                                                          success:^(WCTRCPrivateContactOperateCategoryResponseResult *privateContactOperateCategoryResponseResult)
                                                           {
                                                               blockPrivateContactOperateCategoryResponseResult = [privateContactOperateCategoryResponseResult retain];
                                                               dispatch_group_leave(group);
                                                               
                                                           }
                                                                                                          failure:^(NSError *failureError)
                                                           {
                                                               blockError = [[NSError errorWithDomain:[self errorDomainMessageForError:failureError]
                                                                                                 code:failureError.code
                                                                                           lineNumber:(__LINE__)
                                                                               localizedFailureReason:([failureError.localizedFailureReason length]>0)?failureError.localizedFailureReason:failureError.localizedDescription
                                                                                               object:failureError] retain];
                                                               
                                                               dispatch_group_leave(group);
                                                           }];
            
            if(requestOperation==nil)
            {
                // !! openation是空的時，API內還是會有failure block call回來，所以這邊也要把blockError autorelease
                if(blockError!=nil)
                {
                    [blockError autorelease];
                }
                dispatch_release(group);
                break;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_group_wait(group, DISPATCH_TIME_FOREVER);
            
            //////////////////////////////////////////////////
            
            if(blockPrivateContactOperateCategoryResponseResult!=nil)
            {
                [blockPrivateContactOperateCategoryResponseResult autorelease];
            }
            else if(blockError!=nil)
            {
                [self checkNeedLogoutAndSendNotificationWithError:blockError];
                
                [blockError autorelease];
            }
            
            //////////////////////////////////////////////////
            
            dispatch_release(group);
            
        }while(0);
        
        //////////////////////////////////////////////////
        
        if(error!=nil)
        {
            *error = blockError;
        }
    }
    
    /////////////////////////////////////////////////
    // !! 將錯誤的訊息log下來
    if(blockError)
    {
        [self logMessageWithStartTime:startTime format:@"%s request:%@", __PRETTY_FUNCTION__, contactSetCategoriesRequest];
        [self logMessageWithStartTime:startTime format:@"%s error: %@", __PRETTY_FUNCTION__, blockError];
    }
    
    /////////////////////////////////////////////////
    
    return blockPrivateContactOperateCategoryResponseResult;
}


//================================================================================
// 因為server一次處理太多筆會timeout, 所以另外實作分段處理的API, 不直接使用這個
//================================================================================
- (WCTRCSetOwnerOfContactResponseResult *)_batchSetContactOwnerWithContactGuids:(NSArray *)contactGuids
                                                            newOwnerAccountGuid:(NSString *)newOwnerAccountGuid
                                                                          error:(NSError **)error
{
    NSDate *startTime = [NSDate date];
    
    __block NSError *blockError = nil;
    __block WCTRCSetOwnerOfContactResponseResult  *blockSetOwnerOfContactResponseResult = nil;
    
    //////////////////////////////////////////////////
    
    if([self localModel]==NO)
    {
        do
        {
            WCTRestClient *restClient = [WCTRestClientController curRestClient];
            
            if(restClient==nil)
            {
                blockError = WCTRestClientErrorMake(@"網路傳輸架構 RestClient 不存在",blockError);
                break;
            }
            
            //////////////////////////////////////////////////
            
            //檢查連線狀態是否更新
            if([self checkTimeExpiredAndKeepConnectionWithError:&blockError]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_group_t group = dispatch_group_create();
            
            if(group==NULL)
            {
                blockError = WCTRestClientErrorMake(@"dispatch_group_create 失敗",blockError);
                break;
            }
            
            dispatch_group_enter(group);
            
            //////////////////////////////////////////////////
            
            RKObjectRequestOperation *requestOperation =  [restClient setContactOwnerWithLoginToken:[WCTRestClientController curLoginToken]
                                                                                       contactGuids:contactGuids
                                                                                newOwnerAccountGuid:newOwnerAccountGuid
                                                                                            success:^(WCTRCSetOwnerOfContactResponseResult *setOwnerOfContactResponseResult)
                                                           {
                                                               blockSetOwnerOfContactResponseResult = [setOwnerOfContactResponseResult retain];
                                                               dispatch_group_leave(group);
                                                               
                                                           }
                                                                                            failure:^(NSError *failureError)
                                                           {
                                                               blockError = [[NSError errorWithDomain:[self errorDomainMessageForError:failureError]
                                                                                                 code:failureError.code
                                                                                           lineNumber:(__LINE__)
                                                                               localizedFailureReason:([failureError.localizedFailureReason length]>0)?failureError.localizedFailureReason:failureError.localizedDescription
                                                                                               object:failureError] retain];
                                                               
                                                               dispatch_group_leave(group);
                                                           }];
            
            
            if(requestOperation==nil)
            {
                // !! openation是空的時，API內還是會有failure block call回來，所以這邊也要把blockError autorelease
                if(blockError!=nil)
                {
                    [blockError autorelease];
                }
                dispatch_release(group);
                break;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_group_wait(group, DISPATCH_TIME_FOREVER);
            
            //////////////////////////////////////////////////
            
            if(blockSetOwnerOfContactResponseResult!=nil)
            {
                [blockSetOwnerOfContactResponseResult autorelease];
            }
            else if(blockError!=nil)
            {
                [self checkNeedLogoutAndSendNotificationWithError:blockError];
                
                [blockError autorelease];
            }
            
            //////////////////////////////////////////////////
            
            dispatch_release(group);
            
        }while(0);
        
        //////////////////////////////////////////////////
        
        if(error!=nil)
        {
            *error = blockError;
        }
    }
    
    /////////////////////////////////////////////////
    // !! 將錯誤的訊息log下來
    if(blockError)
    {
        [self logMessageWithStartTime:startTime format:@"%s request:%@ /%@", __PRETTY_FUNCTION__, contactGuids,newOwnerAccountGuid];
        [self logMessageWithStartTime:startTime format:@"%s error: %@", __PRETTY_FUNCTION__, blockError];
    }
    
    /////////////////////////////////////////////////
    
    return blockSetOwnerOfContactResponseResult;
}


//================================================================================
// 因為server一次處理太多筆會timeout, 所以另外實作分段處理的API, 不直接使用這個
//================================================================================
- (WCTRCContactShareAccountResponseResult *)_batchContactShareOperationWithContactShareAccountRequest:(WCTRCContactShareAccountRequest *)contactShareAccountRequest
                                                                                                error:(NSError **)error
{
    NSDate *startTime = [NSDate date];
    
    __block NSError *blockError = nil;
    __block WCTRCContactShareAccountResponseResult  *blockContactShareAccountResponseResult = nil;
    
    //////////////////////////////////////////////////
    
    if([self localModel]==NO)
    {
        do
        {
            WCTRestClient *restClient = [WCTRestClientController curRestClient];
            
            if(restClient==nil)
            {
                blockError = WCTRestClientErrorMake(@"網路傳輸架構 RestClient 不存在",blockError);
                break;
            }
            //////////////////////////////////////////////////
            
            //檢查連線狀態是否更新
            if([self checkTimeExpiredAndKeepConnectionWithError:&blockError]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_group_t group = dispatch_group_create();
            
            if(group==NULL)
            {
                blockError = WCTRestClientErrorMake(@"dispatch_group_create 失敗",blockError);
                break;
            }
            
            dispatch_group_enter(group);
            
            //////////////////////////////////////////////////
            
            RKObjectRequestOperation *requestOperation =  [restClient contactShareOperationWithLoginToken:[WCTRestClientController curLoginToken]
                                                                               contactShareAccountRequest:contactShareAccountRequest
                                                                                                  success:^(WCTRCContactShareAccountResponseResult *contactShareAccountResponseResult)
                                                           {
                                                               blockContactShareAccountResponseResult = [contactShareAccountResponseResult retain];
                                                               dispatch_group_leave(group);
                                                               
                                                           }
                                                                                                  failure:^(NSError *failureError)
                                                           {
                                                               blockError = [[NSError errorWithDomain:[self errorDomainMessageForError:failureError]
                                                                                                 code:failureError.code
                                                                                           lineNumber:(__LINE__)
                                                                               localizedFailureReason:([failureError.localizedFailureReason length]>0)?failureError.localizedFailureReason:failureError.localizedDescription
                                                                                               object:failureError] retain];
                                                               
                                                               dispatch_group_leave(group);
                                                           }];
            
            
            if(requestOperation==nil)
            {
                // !! openation是空的時，API內還是會有failure block call回來，所以這邊也要把blockError autorelease
                if(blockError!=nil)
                {
                    [blockError autorelease];
                }
                dispatch_release(group);
                break;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_group_wait(group, DISPATCH_TIME_FOREVER);
            
            //////////////////////////////////////////////////
            
            if(blockContactShareAccountResponseResult!=nil)
            {
                [blockContactShareAccountResponseResult autorelease];
            }
            else if(blockError!=nil)
            {
                [self checkNeedLogoutAndSendNotificationWithError:blockError];
                
                [blockError autorelease];
            }
            
            //////////////////////////////////////////////////
            
            dispatch_release(group);
            
        }while(0);
        
        //////////////////////////////////////////////////
        
        if(error!=nil)
        {
            *error = blockError;
        }
    }
    
    /////////////////////////////////////////////////
    // !! 將錯誤的訊息log下來
    if(blockError)
    {
        [self logMessageWithStartTime:startTime format:@"%s request:%@", __PRETTY_FUNCTION__, contactShareAccountRequest];
        [self logMessageWithStartTime:startTime format:@"%s error: %@", __PRETTY_FUNCTION__, blockError];
    }
    
    /////////////////////////////////////////////////
    
    return blockContactShareAccountResponseResult;
}


//================================================================================
// 因為server一次處理太多筆會timeout, 所以另外實作分段處理的API, 不直接使用這個
//================================================================================
- (WCTRCPrivateContactDeleteResponseResult *)_batchDeletePrivateContactWithContactGuids:(NSArray *)contactGuids
                                                                                  error:(NSError **)error
{
    NSDate *startTime = [NSDate date];
    
    __block NSError *blockError = nil;
    __block WCTRCPrivateContactDeleteResponseResult  *blockPrivateContactDeleteResponseResult = nil;
    
    //////////////////////////////////////////////////
    
    if([self localModel]==NO)
    {
        do
        {
            WCTRestClient *restClient = [WCTRestClientController curRestClient];
            
            if(restClient==nil)
            {
                blockError = WCTRestClientErrorMake(@"網路傳輸架構 RestClient 不存在",blockError);
                break;
            }
            //////////////////////////////////////////////////
            
            //檢查連線狀態是否更新
            if([self checkTimeExpiredAndKeepConnectionWithError:&blockError]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_group_t group = dispatch_group_create();
            
            if(group==NULL)
            {
                blockError = WCTRestClientErrorMake(@"dispatch_group_create 失敗",blockError);
                break;
            }
            
            dispatch_group_enter(group);
            
            //////////////////////////////////////////////////
            
            RKObjectRequestOperation *requestOperation =  [restClient deletePrivateContactWithLoginToken:[WCTRestClientController curLoginToken]
                                                                                            contactGuids:contactGuids
                                                                                                 success:^(WCTRCPrivateContactDeleteResponseResult *privateContactDeleteResponseResult)
                                                           {
                                                               blockPrivateContactDeleteResponseResult = [privateContactDeleteResponseResult retain];
                                                               dispatch_group_leave(group);
                                                               
                                                           }
                                                                                                 failure:^(NSError *failureError)
                                                           {
                                                               blockError = [[NSError errorWithDomain:[self errorDomainMessageForError:failureError]
                                                                                                 code:failureError.code
                                                                                           lineNumber:(__LINE__)
                                                                               localizedFailureReason:([failureError.localizedFailureReason length]>0)?failureError.localizedFailureReason:failureError.localizedDescription
                                                                                               object:failureError] retain];
                                                               
                                                               dispatch_group_leave(group);
                                                           }];
            
            
            if(requestOperation==nil)
            {
                // !! openation是空的時，API內還是會有failure block call回來，所以這邊也要把blockError autorelease
                if(blockError!=nil)
                {
                    [blockError autorelease];
                }
                dispatch_release(group);
                break;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_group_wait(group, DISPATCH_TIME_FOREVER);
            
            //////////////////////////////////////////////////
            
            if(blockPrivateContactDeleteResponseResult!=nil)
            {
                [blockPrivateContactDeleteResponseResult autorelease];
            }
            else if(blockError!=nil)
            {
                [self checkNeedLogoutAndSendNotificationWithError:blockError];
                
                [blockError autorelease];
            }
            
            //////////////////////////////////////////////////
            
            dispatch_release(group);
            
        }while(0);
    }
    else
    {
        blockPrivateContactDeleteResponseResult = [self localDeletePrivateContactWithContactGuids:contactGuids error:&blockError];
    }
    
    //////////////////////////////////////////////////
    
    if(error!=nil)
    {
        *error = blockError;
    }
    
    /////////////////////////////////////////////////
    // !! 將錯誤的訊息log下來
    if(blockError)
    {
        [self logMessageWithStartTime:startTime format:@"%s request:%@", __PRETTY_FUNCTION__, contactGuids];
        [self logMessageWithStartTime:startTime format:@"%s error: %@", __PRETTY_FUNCTION__, blockError];
    }
    
    /////////////////////////////////////////////////
    
    return blockPrivateContactDeleteResponseResult;
}


//================================================================================
// 因為server一次處理太多筆會timeout, 所以另外實作分段處理的API, 不直接使用這個
//================================================================================
- (WCTRCPrivateContactOperateCategoryResponseResult *)_batchPrivateContactOperateMultiLayerCategoryWithContactSetCategoriesRequest:(WCTRCContactSetCategoriesRequest *)contactSetCategoriesRequest
                                                                                                                   error:(NSError **)error
{
    NSDate *startTime = [NSDate date];
    
    __block NSError *blockError = nil;
    __block WCTRCPrivateContactOperateCategoryResponseResult  *blockPrivateContactOperateCategoryResponseResult = nil;
    
    //////////////////////////////////////////////////
    
    if([self localModel]==NO)
    {
        do
        {
            WCTRestClient *restClient = [WCTRestClientController curRestClient];
            
            if(restClient==nil)
            {
                blockError = WCTRestClientErrorMake(@"網路傳輸架構 RestClient 不存在",blockError);
                break;
            }
            //////////////////////////////////////////////////
            
            //檢查連線狀態是否更新
            if([self checkTimeExpiredAndKeepConnectionWithError:&blockError]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_group_t group = dispatch_group_create();
            
            if(group==NULL)
            {
                blockError = WCTRestClientErrorMake(@"dispatch_group_create 失敗",blockError);
                break;
            }
            
            dispatch_group_enter(group);
            
            //////////////////////////////////////////////////
            
            RKObjectRequestOperation *requestOperation = [restClient privateContactOperateMultiCategoryWithLoginToken:[WCTRestClientController curLoginToken] contactSetCategoriesRequest:contactSetCategoriesRequest
                                                                                                              success:^(WCTRCPrivateContactOperateCategoryResponseResult *privateContactOperateCategoryResponseResult) {
                blockPrivateContactOperateCategoryResponseResult = [privateContactOperateCategoryResponseResult retain];
                dispatch_group_leave(group);
            }
                                                                                                              failure:^(NSError *failureError) {
                blockError = [[NSError errorWithDomain:[self errorDomainMessageForError:failureError]
                                                  code:failureError.code
                                            lineNumber:(__LINE__)
                                localizedFailureReason:([failureError.localizedFailureReason length]>0)?failureError.localizedFailureReason:failureError.localizedDescription
                                                object:failureError] retain];
                
                dispatch_group_leave(group);
            }];
            
          
            if(requestOperation==nil)
            {
                // !! openation是空的時，API內還是會有failure block call回來，所以這邊也要把blockError autorelease
                if(blockError!=nil)
                {
                    [blockError autorelease];
                }
                dispatch_release(group);
                break;
            }
            
            //////////////////////////////////////////////////
            
            dispatch_group_wait(group, DISPATCH_TIME_FOREVER);
            
            //////////////////////////////////////////////////
            
            if(blockPrivateContactOperateCategoryResponseResult!=nil)
            {
                [blockPrivateContactOperateCategoryResponseResult autorelease];
            }
            else if(blockError!=nil)
            {
                [self checkNeedLogoutAndSendNotificationWithError:blockError];
                
                [blockError autorelease];
            }
            
            //////////////////////////////////////////////////
            
            dispatch_release(group);
            
        }while(0);
        
        //////////////////////////////////////////////////
        
        if(error!=nil)
        {
            *error = blockError;
        }
    }
    
    /////////////////////////////////////////////////
    // !! 將錯誤的訊息log下來
    if(blockError)
    {
        [self logMessageWithStartTime:startTime format:@"%s request:%@", __PRETTY_FUNCTION__, contactSetCategoriesRequest];
        [self logMessageWithStartTime:startTime format:@"%s error: %@", __PRETTY_FUNCTION__, blockError];
    }
    
    /////////////////////////////////////////////////
    
    return blockPrivateContactOperateCategoryResponseResult;
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Batch Method

//================================================================================
// MARK: 批次變更聯絡人類別
//================================================================================
- (WCTRCPrivateContactOperateCategoryResponseResult *)batchPrivateContactOperateCategoryWithContactSetCategoriesRequest:(WCTRCContactSetCategoriesRequest *)contactSetCategoriesRequest
                                                                                                        progressHandler:(void(^)(CGFloat progress))progressHandler
                                                                                                                  error:(NSError **)error
{
    WCTRCPrivateContactOperateCategoryResponseResult *fullResult = [[[WCTRCPrivateContactOperateCategoryResponseResult alloc] init] autorelease];
    NSMutableArray *resultData = [NSMutableArray array];
    
    // !! 一次設定的聯絡人大於 WCTRestClientControllerMaxContactGuidPerRequest時，要分段做
    NSInteger numberOfContactGuids = [contactSetCategoriesRequest.contactGuids count];
    NSInteger repeatCount = floor(numberOfContactGuids/WCTRestClientControllerMaxContactGuidPerRequest);    // 要無條件捨去
    NSInteger remaining = numberOfContactGuids-repeatCount*WCTRestClientControllerMaxContactGuidPerRequest;
    
    if (remaining>0)        //有餘數要多做一次
    {
        repeatCount++;
    }
    
    WCTRCContactSetCategoriesRequest *partialRequest = [[WCTRCContactSetCategoriesRequest alloc] init];
    partialRequest.categoryGuids = contactSetCategoriesRequest.categoryGuids;
    partialRequest.behavior = contactSetCategoriesRequest.behavior;
    
    // 回報進度
    if(progressHandler)
    {
        progressHandler(0.0);
    }
    
    NSInteger i = 0;
    
    do
    {
        @autoreleasepool {
            // 取得部分guid
            NSArray *partOfContactGuids = [contactSetCategoriesRequest.contactGuids subarrayWithRange:NSMakeRange(i*WCTRestClientControllerMaxContactGuidPerRequest, (i+((remaining==0)?0:1)<repeatCount)?WCTRestClientControllerMaxContactGuidPerRequest:remaining)];
            
            // 設定部分guid
            partialRequest.contactGuids = partOfContactGuids;
            
            WCTRCPrivateContactOperateCategoryResponseResult *result = [self _batchPrivateContactOperateCategoryWithContactSetCategoriesRequest:partialRequest
                                                                                                                                          error:error];
            
            if (result==nil)
            {
                if(error)
                {
                    [(*error) retain];
                }
                break;
            }
            
            // 記錄回傳值
            fullResult.errorCode = result.errorCode;
            fullResult.errorData = result.errorData;
            fullResult.exceptionMessage = result.exceptionMessage;
            fullResult.message = result.message;
            
            if([result.data count]>0)
            {
                [resultData addObjectsFromArray:result.data];
            }
            
            i++;
            
            // 回報進度
            if(progressHandler)
            {
                progressHandler((CGFloat)i/(CGFloat)repeatCount);
            }

        }
        
    } while (numberOfContactGuids>i*WCTRestClientControllerMaxContactGuidPerRequest);
    
    [partialRequest release];
    
    fullResult.data = resultData;
    
    // 回報進度
    if(progressHandler)
    {
        progressHandler(1.0);
    }
    
    // !! 如果有錯誤，回傳nil
    if(error!=NULL && *error!=nil)
    {
        [(*error) autorelease];
        
        fullResult = nil;
    }
    
    return fullResult;
}


//================================================================================
// MARK: 批次變更聯絡人擁有者
//================================================================================
- (WCTRCSetOwnerOfContactResponseResult *)batchSetContactOwnerWithContactGuids:(NSArray *)contactGuids
                                                           newOwnerAccountGuid:(NSString *)newOwnerAccountGuid
                                                               progressHandler:(void(^)(CGFloat progress))progressHandler
                                                                         error:(NSError **)error
{
    WCTRCSetOwnerOfContactResponseResult *fullResult = [[[WCTRCSetOwnerOfContactResponseResult alloc] init] autorelease];
    NSMutableArray *resultData = [NSMutableArray array];
    
    // !! 一次設定的聯絡人大於 WCTRestClientControllerMaxContactGuidPerRequest時，要分段做
    NSInteger numberOfContactGuids = [contactGuids count];
    NSInteger repeatCount = floor(numberOfContactGuids/WCTRestClientControllerMaxContactGuidPerRequest);    // 要無條件捨去
    NSInteger remaining = numberOfContactGuids-repeatCount*WCTRestClientControllerMaxContactGuidPerRequest;
    
    if (remaining>0)        //有餘數要多做一次
    {
        repeatCount++;
    }
    
    //////////////////////////////////////////////////
    // 回報進度
    if(progressHandler)
    {
        progressHandler(0.0);
    }
    
    
    NSInteger i = 0;
    
    do
    {
        @autoreleasepool {
            // 取得部分guid
            NSArray *partOfContactGuids = [contactGuids subarrayWithRange:NSMakeRange(i*WCTRestClientControllerMaxContactGuidPerRequest, (i+((remaining==0)?0:1)<repeatCount)?WCTRestClientControllerMaxContactGuidPerRequest:remaining)];
            
            
            WCTRCSetOwnerOfContactResponseResult *result = [self _batchSetContactOwnerWithContactGuids:partOfContactGuids
                                                                                   newOwnerAccountGuid:newOwnerAccountGuid
                                                                                                 error:error];
            
            if (result==nil)
            {
                if(error)
                {
                    [(*error) retain];
                }
                break;
            }
            
            // 記錄回傳值
            fullResult.errorCode = result.errorCode;
            fullResult.errorData = result.errorData;
            fullResult.exceptionMessage = result.exceptionMessage;
            fullResult.message = result.message;
            
            if([result.data count]>0)
            {
                [resultData addObjectsFromArray:result.data];
            }
            
            i++;
            
            // 回報進度
            if(progressHandler)
            {
                progressHandler((CGFloat)i/(CGFloat)repeatCount);
            }
        }
        
    } while (numberOfContactGuids>i*WCTRestClientControllerMaxContactGuidPerRequest);
    
    fullResult.data = resultData;
    
    // !! 如果有錯誤，回傳nil
    if(error!=NULL && *error!=nil)
    {
        [(*error) autorelease];

        fullResult = nil;
    }
  
    return fullResult;
}


//================================================================================
// MARK: 批次分享聯絡人
//================================================================================
- (WCTRCContactShareAccountResponseResult *)batchContactShareOperationWithContactShareAccountRequest:(WCTRCContactShareAccountRequest *)contactShareAccountRequest
                                                                                     progressHandler:(void(^)(CGFloat progress))progressHandler
                                                                                               error:(NSError **)error
{
    WCTRCContactShareAccountResponseResult *fullResult = [[[WCTRCContactShareAccountResponseResult alloc] init] autorelease];
  
    // !! 一次設定的聯絡人大於 WCTRestClientControllerMaxContactGuidPerRequest時，要分段做
    NSInteger numberOfContactGuids = [contactShareAccountRequest.contactGuids count];
    NSInteger repeatCount = floor(numberOfContactGuids/WCTRestClientControllerMaxContactGuidPerRequest);    // 要無條件捨去
    NSInteger remaining = numberOfContactGuids-repeatCount*WCTRestClientControllerMaxContactGuidPerRequest;
    
    if (remaining>0)        //有餘數要多做一次
    {
        repeatCount++;
    }
    
    
    //////////////////////////////////////////////////
    // 回報進度
    if(progressHandler)
    {
        progressHandler(0.0);
    }

    NSInteger i = 0;
    
    do
    {
        @autoreleasepool {
            // 取得部分guid
            NSArray *partOfContactGuids = [contactShareAccountRequest.contactGuids subarrayWithRange:NSMakeRange(i*WCTRestClientControllerMaxContactGuidPerRequest, (i+((remaining==0)?0:1)<repeatCount)?WCTRestClientControllerMaxContactGuidPerRequest:remaining)];
            
            //////////////////////////////////////////////////
            
            WCTRCContactShareAccountRequest *partOfShareAccountRequest = [[[WCTRCContactShareAccountRequest alloc] init] autorelease];
            
            if(partOfShareAccountRequest==nil)
            {
                break;
            }
            
            partOfShareAccountRequest.contactGuids = partOfContactGuids;
            partOfShareAccountRequest.accountGuids = contactShareAccountRequest.accountGuids;
            partOfShareAccountRequest.shareBehavior = contactShareAccountRequest.shareBehavior;
            
            //////////////////////////////////////////////////
            
            WCTRCContactShareAccountResponseResult *result = [self _batchContactShareOperationWithContactShareAccountRequest:partOfShareAccountRequest error:error];
            
            if (result==nil)
            {
                if(error)
                {
                    [(*error) retain];
                }
                break;
            }
            
            // 記錄回傳值
            fullResult.errorCode = result.errorCode;
            fullResult.data = result.data;
            fullResult.exceptionMessage = result.exceptionMessage;
            fullResult.message = result.message;
        
            i++;
            
            // 回報進度
            if(progressHandler)
            {
                progressHandler((CGFloat)i/(CGFloat)repeatCount);
            }
        }
        
    } while (numberOfContactGuids>i*WCTRestClientControllerMaxContactGuidPerRequest);
  
    // 回報進度
    if(progressHandler)
    {
        progressHandler(1.0);
    }

    
    // !! 如果有錯誤，回傳nil
    if(error!=NULL && *error!=nil)
    {
        [(*error) autorelease];
        
        fullResult = nil;
    }
    
    return fullResult;
}


//================================================================================
// MARK: 批次刪除聯絡人
//================================================================================
- (WCTRCPrivateContactDeleteResponseResult *)batchDeletePrivateContactWithContactGuids:(NSArray *)contactGuids
                                                                       progressHandler:(void(^)(CGFloat progress))progressHandler
                                                                                 error:(NSError **)error
{
    WCTRCPrivateContactDeleteResponseResult *fullResult = [[[WCTRCPrivateContactDeleteResponseResult alloc] init] autorelease];
    NSMutableArray *resultData = [NSMutableArray array];
    
    // !! 一次設定的聯絡人大於 WCTRestClientControllerMaxContactGuidPerRequest時，要分段做
    NSInteger numberOfContactGuids = [contactGuids count];
    NSInteger repeatCount = floor(numberOfContactGuids/WCTRestClientControllerMaxContactGuidPerRequest);    // 要無條件捨去
    NSInteger remaining = numberOfContactGuids-repeatCount*WCTRestClientControllerMaxContactGuidPerRequest;
    
    if (remaining>0)        //有餘數要多做一次
    {
        repeatCount++;
    }
    
    //////////////////////////////////////////////////
    // 回報進度
    if(progressHandler)
    {
        progressHandler(0.0);
    }

    
    NSInteger i = 0;
    
    do
    {
        @autoreleasepool {
            // 取得部分guid
            NSArray *partOfContactGuids = [contactGuids subarrayWithRange:NSMakeRange(i*WCTRestClientControllerMaxContactGuidPerRequest, (i+((remaining==0)?0:1)<repeatCount)?WCTRestClientControllerMaxContactGuidPerRequest:remaining)];
            
            
            WCTRCPrivateContactDeleteResponseResult *result = [self _batchDeletePrivateContactWithContactGuids:partOfContactGuids
                                                                                                         error:error];
            
            if (result==nil)
            {
                if(error)
                {
                    [(*error) retain];
                }
                break;
            }
            
            // 記錄回傳值
            fullResult.errorCode = result.errorCode;
            fullResult.errorData = result.errorData;
            fullResult.exceptionMessage = result.exceptionMessage;
            fullResult.message = result.message;
            if([result.data count]>0)
            {
                [resultData addObjectsFromArray:result.data];
            }
            i++;
            
            // 回報進度
            if(progressHandler)
            {
                progressHandler((CGFloat)i/(CGFloat)repeatCount);
            }
        }
        
    } while (numberOfContactGuids>i*WCTRestClientControllerMaxContactGuidPerRequest);
    
    fullResult.data = resultData;
    
    // 回報進度
    if(progressHandler)
    {
        progressHandler(1.0);
    }
    
    // !! 如果有錯誤，回傳nil
    if(error!=NULL && *error!=nil)
    {
        [(*error) autorelease];

        fullResult = nil;
    }
    
    return fullResult;
}


//================================================================================
// MARK: 批次變更聯絡人多層類別
//================================================================================
- (WCTRCPrivateContactOperateCategoryResponseResult *)batchPrivateContactOperateMultiLayerCategoryWithContactSetCategoriesRequest:(WCTRCContactSetCategoriesRequest *)contactSetCategoriesRequest
                                                                                                                  progressHandler:(void(^)(CGFloat progress))progressHandler
                                                                                                                            error:(NSError **)error
{
    WCTRCPrivateContactOperateCategoryResponseResult *fullResult = [[[WCTRCPrivateContactOperateCategoryResponseResult alloc] init] autorelease];
    NSMutableArray *resultData = [NSMutableArray array];
    
    // !! 一次設定的聯絡人大於 WCTRestClientControllerMaxContactGuidPerRequest時，要分段做
    NSInteger numberOfContactGuids = [contactSetCategoriesRequest.contactGuids count];
    NSInteger repeatCount = floor(numberOfContactGuids/WCTRestClientControllerMaxContactGuidPerRequest);    // 要無條件捨去
    NSInteger remaining = numberOfContactGuids-repeatCount*WCTRestClientControllerMaxContactGuidPerRequest;
    
    if (remaining>0)        //有餘數要多做一次
    {
        repeatCount++;
    }
    
    WCTRCContactSetCategoriesRequest *partialRequest = [[WCTRCContactSetCategoriesRequest alloc] init];
    partialRequest.categoryGuids = contactSetCategoriesRequest.categoryGuids;
    partialRequest.behavior = contactSetCategoriesRequest.behavior;
    
    // 回報進度
    if(progressHandler)
    {
        progressHandler(0.0);
    }
    
    NSInteger i = 0;
    
    do
    {
        @autoreleasepool {
            // 取得部分guid
            NSArray *partOfContactGuids = [contactSetCategoriesRequest.contactGuids subarrayWithRange:NSMakeRange(i*WCTRestClientControllerMaxContactGuidPerRequest, (i+((remaining==0)?0:1)<repeatCount)?WCTRestClientControllerMaxContactGuidPerRequest:remaining)];
            
            // 設定部分guid
            partialRequest.contactGuids = partOfContactGuids;
            
            WCTRCPrivateContactOperateCategoryResponseResult *result = [self _batchPrivateContactOperateMultiLayerCategoryWithContactSetCategoriesRequest:partialRequest
                                                                                                                                          error:error];
            
            if (result==nil)
            {
                if(error)
                {
                    [(*error) retain];
                }
                break;
            }
            
            // 記錄回傳值
            fullResult.errorCode = result.errorCode;
            fullResult.errorData = result.errorData;
            fullResult.exceptionMessage = result.exceptionMessage;
            fullResult.message = result.message;
            
            if([result.data count]>0)
            {
                [resultData addObjectsFromArray:result.data];
            }
            
            i++;
            
            // 回報進度
            if(progressHandler)
            {
                progressHandler((CGFloat)i/(CGFloat)repeatCount);
            }
            
        }
        
    } while (numberOfContactGuids>i*WCTRestClientControllerMaxContactGuidPerRequest);
    
    [partialRequest release];
    
    fullResult.data = resultData;
    
    // 回報進度
    if(progressHandler)
    {
        progressHandler(1.0);
    }
    
    // !! 如果有錯誤，回傳nil
    if(error!=NULL && *error!=nil)
    {
        [(*error) autorelease];
        
        fullResult = nil;
    }
    
    return fullResult;
}
@end
