//
//  WCTRestClientController+Batch.h
//
//
//  Created by Howard on 2017/4/7.
//
//

#import <WCTRestClientController/WCTRestClientController.h>


@interface WCTRestClientController (Batch)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Batch Method


/**
 批次聯絡人類別操作

 @param contactSetCategoriesRequest 需求模式
 @param progressHandler 回報處理進度
 @param error 回傳錯誤
 @return 結果
 */
- (WCTRCPrivateContactOperateCategoryResponseResult *)batchPrivateContactOperateCategoryWithContactSetCategoriesRequest:(WCTRCContactSetCategoriesRequest *)contactSetCategoriesRequest
                                                                                                        progressHandler:(void(^)(CGFloat progress))progressHandler
                                                                                                                  error:(NSError **)error;



/**
 批次變更聯絡人擁有者

 @param contactGuids 聯絡人 ids
 @param newOwnerAccountGuid 帳號 ids
 @param progressHandler 回報處理進度
 @param error 回傳錯誤
 @return 結果
 */
- (WCTRCSetOwnerOfContactResponseResult *)batchSetContactOwnerWithContactGuids:(NSArray *)contactGuids
                                                           newOwnerAccountGuid:(NSString *)newOwnerAccountGuid
                                                               progressHandler:(void(^)(CGFloat progress))progressHandler
                                                                         error:(NSError **)error;




/**
 批次分享聯絡人
 
 @param contactShareAccountRequest 需求模型
 @param progressHandler 回報處理進度
 @param error 回傳錯誤
 @return 結果
 */
- (WCTRCContactShareAccountResponseResult *)batchContactShareOperationWithContactShareAccountRequest:(WCTRCContactShareAccountRequest *)contactShareAccountRequest
                                                                                     progressHandler:(void(^)(CGFloat progress))progressHandler
                                                                                               error:(NSError **)error;

/**
 批次刪除聯絡人

 @param contactGuids 聯絡人 ids
 @param progressHandler 回報處理進度
 @param error 回傳錯誤
 @return 結果
 */
- (WCTRCPrivateContactDeleteResponseResult *)batchDeletePrivateContactWithContactGuids:(NSArray *)contactGuids
                                                                       progressHandler:(void(^)(CGFloat progress))progressHandler
                                                                                 error:(NSError **)error;


/**
 批次聯絡人多層類別操作
 
 @param contactSetCategoriesRequest 需求模式
 @param progressHandler 回報處理進度
 @param error 回傳錯誤
 @return 結果
 */
- (WCTRCPrivateContactOperateCategoryResponseResult *)batchPrivateContactOperateMultiLayerCategoryWithContactSetCategoriesRequest:(WCTRCContactSetCategoriesRequest *)contactSetCategoriesRequest
                                                                                                                  progressHandler:(void(^)(CGFloat progress))progressHandler
                                                                                                                            error:(NSError **)error;
@end
