//
//  WCTRCMessageResponseResult.m
//  
//
//  Created by Howard on 2016/3/11.
//
//

#import "WCTRCMessageResponseResult.h"

@implementation WCTRCMessageResponseResult

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_data release];
    _data = nil;
    
    [_message release];
    _message = nil;
    
    [_errorData release];
    _errorData = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{data:%@, message:%@, errorData:%@}",
            [super description],
            self.data,
            self.message,
            self.errorData];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCMessageResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.data = [[self.data copyWithZone:zone] autorelease];
            object.message = [[self.message copyWithZone:zone] autorelease];
            object.errorData = [[self.errorData copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"message":@"message",
                                                 @"data":@"data",
                                                 @"errorData":@"errorData"}];
    }
    
    return responseMapping;
}

@end
