//
//  WCTRCListResponseResult.m
//  
//
//  Created by Howard on 2016/3/11.
//
//

#import "WCTRCListResponseResult.h"

@implementation WCTRCListResponseResult

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_data release];
    _data = nil;
    
    [_message release];
    _message = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{data:%@, message:%@}",
            [super description],
            self.data,
            self.message];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCListResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.data = [[self.data copyWithZone:zone] autorelease];
            object.message = [[self.message copyWithZone:zone] autorelease];
        }
    }
    
    return object;

}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    // 因為 data 陣列內的變數可能不一樣，所以用子類別決定 mapping 的方法
    return [super responseMapping];
}
@end
