//
//  WCTRCVersionInfo.m
//  
//
//  Created by Howard on 2016/10/5.
//
//

#import "WCTRCVersionInfo.h"

@implementation WCTRCVersionInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_apiName release];
    _apiName = nil;
    
    [_version release];
    _version = nil;
    
    [_describe release];
    _describe = nil;
    
    [_serverType release];
    _serverType = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{serverType:%@, apiName:%@, description:%@, major:%td, minor:%td, release: %td, nubmer:%td, version:%@}",
            [super description],
            self.serverType,
            self.apiName,
            self.describe,
            self.major,
            self.minor,
            self.patch,
            self.number,
            self.version];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCVersionInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.serverType = [[self.apiName copyWithZone:zone] autorelease];
            object.apiName = [[self.apiName copyWithZone:zone] autorelease];
            object.describe = [[self.describe copyWithZone:zone] autorelease];
            object.major = self.major;
            object.minor = self.minor;
            object.patch = self.patch;
            object.number = self.number;
            object.version = [[self.version copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"apiName":@"apiName",
                                                              @"serverType":@"serverType",
                                                              @"describe":@"describe",
                                                              @"major":@"major",
                                                              @"minor":@"minor",
                                                              @"release":@"patch",
                                                              @"number":@"number",
                                                              @"version":@"version"}];
        
    }
    
    return responseMapping;
}


@end
