//
//  WCTRCUIDisplayOption.m
//  WCTRestClientController
//
//  Created by sanhue cheng on 2021/3/2.
//

#import "WCTRCUIDisplayOption.h"

@implementation WCTRCUIDisplayOption

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_custom release];
    _custom = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{custom:%@, isCloud:%@,isIsMultiCompany:%@, isIsSupportSubscription:%@, isSimplyUI:%@,isHideExportFunction:%@,isHideCrm:%@,isHideContactServer:%@,isHideMycard:%@,isSupportApplyAccount:%@,isSupportBackupRestore:%@,isSupportPcs:%@, isSupportRetistry:%@, isSupportSecuritySetting:%@}",
            [super description],
            self.custom,
            self.isCloud?@"YES":@"NO",
            self.isIsMultiCompany?@"YES":@"NO",
            self.isIsSupportSubscription?@"YES":@"NO",
            self.isSimplyUI?@"YES":@"NO",
            self.isHideExportFunction?@"YES":@"NO",
            self.isHideCrm?@"YES":@"NO",
            self.isHideContactServer?@"YES":@"NO",
            self.isHideMycard?@"YES":@"NO",
            self.isSupportApplyAccount?@"YES":@"NO",
            self.isSupportBackupRestore?@"YES":@"NO",
            self.isSupportPcs?@"YES":@"NO",
            self.isSupportRetistry?@"YES":@"NO",
            self.isSupportSecuritySetting?@"YES":@"NO"];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCUIDisplayOption *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.custom = [[self.custom copyWithZone:zone] autorelease];
            object.isCloud = self.isCloud;
            object.isIsMultiCompany = self.isIsMultiCompany;
            object.isIsSupportSubscription = self.isIsSupportSubscription;
            object.isSimplyUI = self.isSimplyUI;
            object.isHideExportFunction = self.isHideExportFunction;
            object.isHideCrm = self.isHideCrm;
            object.isHideContactServer = self.isHideContactServer;
            object.isHideMycard = self.isHideMycard;
            object.isSupportApplyAccount = self.isSupportApplyAccount;
            object.isSupportBackupRestore = self.isSupportBackupRestore;
            object.isSupportPcs = self.isSupportPcs;
            object.isSupportRetistry = self.isSupportRetistry;
            object.isSupportSecuritySetting = self.isSupportSecuritySetting;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"custom":@"custom",
                                                              @"isCloud":@"isCloud",
                                                              @"isIsMultiCompany":@"isIsMultiCompany",
                                                              @"isIsSupportSubscription":@"isIsSupportSubscription",
                                                              @"isSimplyUI":@"isSimplyUI",
                                                              @"isHideExportFunction":@"isHideExportFunction",
                                                              @"isHideCrm":@"isHideCrm",
                                                              @"isHideContactServer":@"isHideContactServer",
                                                              @"isHideMycard":@"isHideMycard",
                                                              @"isSupportApplyAccount":@"isSupportApplyAccount",
                                                              @"isSupportBackupRestore":@"isSupportBackupRestore",
                                                              @"isSupportPcs":@"isSupportPcs",
                                                              @"isSupportRetistry":@"isSupportRetistry",
                                                              @"isSupportSecuritySetting":@"isSupportSecuritySetting"}];
        
    }
    
    return responseMapping;
}


@end
