//
//  WCTRCServerRegisterStatusResponseResult.m
//
//
//  Created by Howard on 2017/7/17.
//
//

#import "WCTRCServerRegisterStatusResponseResult.h"

@implementation WCTRCServerRegisterStatusResponseResult



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_data release];
    _data = nil;
    
    [_errorData release];
    _errorData = nil;
    
    [_message release];
    _message = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{data:%@, errorData:%@, message:%@}",
            [super description],
            self.data,
            self.errorData,
            self.message];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCServerRegisterStatusResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.data = [[self.data copyWithZone:zone] autorelease];
            object.errorData = [[self.errorData copyWithZone:zone] autorelease];
            object.message = [[self.message copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"data":@"data",
                                                              @"errorData":@"errorData",
                                                              @"message":@"message"}];
        
    }
    
    return responseMapping;
}


@end
