//
//  WCTRCSyncInfo.m
//  
//
//  Created by sanhue on 2016/4/11.
//
//

#import "WCTRCSyncInfo.h"

// Controller
#import "PPSettingsController.h"

// Define
#import "WCTRestClientController+SettingsKey.h"

@implementation WCTRCSyncInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountGuid release];
    _accountGuid = nil;
    
    [_categoryLastRecTime release];
    _categoryLastRecTime = nil;
    
    [_categorySyncInfoList release];
    _categorySyncInfoList = nil;
    
    [_contactLastRecTime release];
    _contactLastRecTime = nil;
    
    [_contactSyncInfoList release];
    _contactSyncInfoList = nil;
    
    [_contactContinueSeekTime release];
    _contactContinueSeekTime = nil;
    
    [_firstSyncTime release];
    _firstSyncTime = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountGuid:%@, firstSyncTime:%@, categoryLastRecTime:%@, \
            categorySyncInfoList:%@, contactLastRecTime:%@, contactSyncInfoList:%@ \
            isCategoryFirstSync:%@, isContactFirstSync:%@, contactContinueSeekTime:%@, isContactContinueSeek:%@}",
            [super description],
            self.accountGuid,
            self.firstSyncTime,
            self.categoryLastRecTime,
            self.categorySyncInfoList,
            self.contactLastRecTime,
            self.contactSyncInfoList,
            self.isCategoryFirstSync?@"YES":@"NO",
            self.isContactFirstSync?@"YES":@"NO",
            self.contactContinueSeekTime,
            self.isContactContinueSeek?@"YES":@"NO"];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCSyncInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountGuid = [[self.accountGuid copyWithZone:zone] autorelease];
            object.firstSyncTime = [[self.firstSyncTime copyWithZone:zone] autorelease];
            object.categoryLastRecTime = [[self.categoryLastRecTime copyWithZone:zone] autorelease];
            object.categorySyncInfoList = [[self.categorySyncInfoList copyWithZone:zone] autorelease];
            object.contactLastRecTime = [[self.contactLastRecTime copyWithZone:zone] autorelease];
            object.contactSyncInfoList = [[self.contactSyncInfoList copyWithZone:zone] autorelease];
            object.isCategoryFirstSync = self.isCategoryFirstSync;
            object.isContactFirstSync = self.isContactFirstSync;
            object.contactContinueSeekTime = [[self.contactContinueSeekTime copyWithZone:zone] autorelease];
            object.isContactContinueSeek = self.isContactContinueSeek;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];

    if(responseMapping!=nil)
    {
        if([[PPSettingsController stringValueWithKey:WCTRestClientController_SettingsKey_SupportedMinimumVersion] floatValue]>=4.0)
        {
            [responseMapping addAttributeMappingsFromDictionary:@{@"accountGuid" : @"accountGuid",
                                                                  @"firstSyncTime" : @"firstSyncTime",
                                                                  @"isContactContinueSeek": @"isContactContinueSeek",
                                                                  @"contactLastRecTime" : @"contactLastRecTime",
                                                                  @"isContactFirstSync" : @"isContactFirstSync",
                                                                  @"contactContinueSeekTime" : @"contactContinueSeekTime"}];
        }
        else
        {
            [responseMapping addAttributeMappingsFromDictionary:@{@"accountGuid" : @"accountGuid",
                                                                  @"firstSyncTime" : @"firstSyncTime",
                                                                  @"categoryLastRecTime" : @"categoryLastRecTime",
                                                                  @"contactLastRecTime" : @"contactLastRecTime",
                                                                  @"isCategoryFirstSync" : @"isCategoryFirstSync",
                                                                  @"isContactFirstSync" : @"isContactFirstSync",
                                                                  @"contactContinueSeekTime" : @"contactContinueSeekTime",
                                                                  @"isContactContinueSeek": @"isContactContinueSeek"}];
            
            
            //////////////////////////////////////////////////
            
            [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"categorySyncInfoList"
                                                                                            toKeyPath:@"categorySyncInfoList"
                                                                                          withMapping:[WCTRCCategorySyncInfo responseMapping]]];
            
        }
        

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"contactSyncInfoList"
                                                                                        toKeyPath:@"contactSyncInfoList"
                                                                                      withMapping:[WCTRCContactSyncInfo responseMapping]]];
    }
    
    return responseMapping;
}

@end
