//
//  WCTRCContactUpdateCheckRequest.m
//  Pods
//
//  Created by sanhue on 2016/8/30.
//
//

#import "WCTRCContactUpdateCheckRequest.h"

@implementation WCTRCContactUpdateCheckRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{

    self.accountGuid = nil;
    self.sharedAccountSHA1 = nil;
    self.backImageSHA1 = nil;
    self.categorySHA1 = nil;
    self.contactGuid = nil;
    self.contentSHA1 = nil;
    self.frontImageSHA1 = nil;
    self.lastModifyTime = nil;
    self.logoSHA1 = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountGuid:%@, sharedAccountSHA1:%@, backImageSHA1:%@, categorySHA1:%@, contactGuid:%@, contentSHA1:%@, frontImageSHA1:%@, lastModifyTime:%@, logoSHA1:%@}",
            [super description],
            self.accountGuid,
            self.sharedAccountSHA1,
            self.backImageSHA1,
            self.categorySHA1,
            self.contactGuid,
            self.contentSHA1,
            self.frontImageSHA1,
            self.lastModifyTime,
            self.logoSHA1];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactUpdateCheckRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountGuid = [[self.accountGuid copyWithZone:zone] autorelease];
            object.sharedAccountSHA1 = [[self.sharedAccountSHA1 copyWithZone:zone] autorelease];
            object.backImageSHA1 = [[self.backImageSHA1 copyWithZone:zone] autorelease];
            object.categorySHA1 = [[self.categorySHA1 copyWithZone:zone] autorelease];
            object.contactGuid = [[self.contactGuid copyWithZone:zone] autorelease];
            object.contentSHA1 = [[self.contentSHA1 copyWithZone:zone] autorelease];
            object.frontImageSHA1 = [[self.frontImageSHA1 copyWithZone:zone] autorelease];
            object.lastModifyTime = [[self.lastModifyTime copyWithZone:zone] autorelease];
            object.logoSHA1 = [[self.logoSHA1 copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountGuid":@"accountGuid",
                                                              @"accountcanviewSHA1":@"sharedAccountSHA1",
                                                              @"backImageSHA1":@"backImageSHA1",
                                                              @"categorySHA1":@"categorySHA1",
                                                              @"contactGuid":@"contactGuid",
                                                              @"contentSHA1":@"contentSHA1",
                                                              @"frontImageSHA1":@"frontImageSHA1",
                                                              @"lastModifyTime":@"lastModifyTime",
                                                              @"logoSHA1":@"logoSHA1"}];
        
    }
    
    return responseMapping;
}

@end
