//
//  WCTRCCategoryCompareAction.m
//  Pods
//
//  Created by sanhue on 2016/4/9.
//
//

#import "WCTRCCategoryCompareAction.h"

@implementation WCTRCCategoryCompareAction

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_categoryGuid release];
    _categoryGuid = nil;
    
    [_categoryName release];
    _categoryName = nil;
    
    [_categoryType release];
    _categoryType = nil;
    
    [_modifyTime release];
    _modifyTime = nil;
    
    [_updateAction release];
    _updateAction = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{categoryGuid:%@, categoryName:%@, categoryType:%@, modifyTime:%@, updateAction:%@}",
            [super description],
            self.categoryGuid,
            self.categoryName,
            self.categoryType,
            self.modifyTime,
            self.updateAction];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCategoryCompareAction *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.categoryGuid = [[self.categoryGuid copyWithZone:zone] autorelease];
            object.categoryName = [[self.categoryName copyWithZone:zone] autorelease];
            object.categoryType = [[self.categoryType copyWithZone:zone] autorelease];
            object.modifyTime = [[self.modifyTime copyWithZone:zone] autorelease];
            object.updateAction = [[self.updateAction copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"categoryGuid":@"categoryGuid",
                                                              @"categoryName":@"categoryName",
                                                              @"categoryType":@"categoryType",
                                                              @"modifyTime":@"modifyTime",
                                                              @"updateAction":@"updateAction"}];
    }
    
    return responseMapping;
}

@end
