//
//  WCTRCSubscriptionPeriod.m
//
//
//  Created by Howard on 2018/9/10.
//

#import "WCTRCSubscriptionPeriod.h"

@implementation WCTRCSubscriptionPeriod


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.subscriptionType = nil;
    self.timRangeEnd = nil;
    self.timRangeStart = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountNumber:%td, subscriptionType:%@, timRangeEnd:%@, timRangeStart:%@}",
            [super description],
            self.accountNumber,
            self.subscriptionType,
            self.timRangeEnd,
            self.timRangeStart];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCSubscriptionPeriod *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountNumber = self.accountNumber;
                                    
            object.subscriptionType = [[self.subscriptionType copyWithZone:zone] autorelease];
            object.timRangeStart = [[self.timRangeStart copyWithZone:zone] autorelease];
            object.timRangeEnd = [[self.timRangeEnd copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountNumber":@"accountNumber",
                                                              @"subscriptionType":@"subscriptionType",
                                                              @"timRangeEnd":@"timRangeEnd",
                                                              @"timRangeStart":@"timRangeStart"}];
        
    }
    
    return responseMapping;
}
@end
