//
//  WCTRCSubscriptionInfoVo.m
//  
//
//  Created by Howard on 2018/9/10.
//

#import "WCTRCSubscriptionInfoVo.h"

@implementation WCTRCSubscriptionInfoVo


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.companyName = nil;
    self.contactName = nil;
    self.countryID = nil;
    self.currentDateTime = nil;
    self.email = nil;
    self.expiredDateTime = nil;
    self.oldServiceID = nil;
    self.phone = nil;
    self.serviceId = nil;
    self.subscriptionInfos = nil;
    self.wctVersion = nil;
    self.webVersion = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{companyName:%@, contactName:%@, countryID:%@, currentDateTime:%@, email:%@, expiredDateTime:%@, oldServiceID:%@, phone:%@, serviceId:%@, subscriptionInfos:%@, wctVersion:%@, webVersion:%@}",
            [super description],
            self.companyName,
            self.contactName,
            self.countryID,
            self.currentDateTime,
            self.email,
            self.expiredDateTime,
            self.oldServiceID,
            self.phone,
            self.serviceId,
            self.subscriptionInfos,
            self.wctVersion,
            self.webVersion];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCSubscriptionInfoVo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.companyName = [[self.companyName copyWithZone:zone] autorelease];
            object.contactName = [[self.contactName copyWithZone:zone] autorelease];
            object.countryID = [[self.countryID copyWithZone:zone] autorelease];
            object.currentDateTime = [[self.currentDateTime copyWithZone:zone] autorelease];
            object.email = [[self.email copyWithZone:zone] autorelease];
            object.expiredDateTime = [[self.expiredDateTime copyWithZone:zone] autorelease];
            object.oldServiceID = [[self.oldServiceID copyWithZone:zone] autorelease];
            object.phone = [[self.phone copyWithZone:zone] autorelease];
            object.serviceId = [[self.serviceId copyWithZone:zone] autorelease];
            object.subscriptionInfos = [[self.subscriptionInfos copyWithZone:zone] autorelease];
            object.wctVersion = [[self.wctVersion copyWithZone:zone] autorelease];
            object.webVersion = [[self.webVersion copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"companyName":@"companyName",
                                                              @"contactName":@"contactName",
                                                              @"countryID":@"coutryID",
                                                              @"currentDateTime":@"currentDateTime",
                                                              @"email":@"email",
                                                              @"expiredDateTime":@"expiredDateTime",
                                                              @"oldServiceID":@"oldServiceId",
                                                              @"phone":@"phone",
                                                              @"serviceId":@"serviceId",
                                                     @"wctVersion":@"wctVersione",
                                                              @"webVersion":@"webVersion",
                                                              }];
        
        //////////////////////////////////////////////////

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"subscriptionInfos"
                                                                                        toKeyPath:@"subscriptionInfos"
                                                                                      withMapping:[WCTRCSubscriptionPeriod responseMapping]]];
        
    }

    return responseMapping;
}

@end
