//
//  WCTRCStorageInfo.m
//  
//
//  Created by Howard on 2016/3/11.
//
//

#import "WCTRCStorageInfo.h"

@implementation WCTRCStorageInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_capacity release];
    _capacity = nil;
    
    [_freeSpace release];
    _freeSpace = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{capacity:%@, freeSpace:%@}",
            [super description],
            self.capacity,
            self.freeSpace];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCStorageInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.capacity = [[self.capacity copyWithZone:zone] autorelease];
            object.freeSpace = [[self.freeSpace copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"capacity":@"capacity",
                                                              @"freeSpace":@"freeSpace"}];
    }
    
    return responseMapping;
}
@end
