//
//  WCTRCAdvancedSearchVoRequest.m
//  ADAL
//
//  Created by sanhue on 2018/4/26.
//

#import "WCTRCAdvancedSearchVoRequest.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTRCAdvancedSearchVoRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    
    if (self)
    {
        _advancedSearchInfo = [[WCTRCAdvancedSearchInfo alloc] init];
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_advancedSearchInfo release];
    _advancedSearchInfo = nil;
    
    [_contactRangeType release];
    _contactRangeType = nil;
    
    [_contactSimpleInfoSortField release];
    _contactSimpleInfoSortField = nil;
    
    [_sortDirection release];
    _sortDirection = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{advancedSearchInfo:%@, contactRangeType:%@, contactSimpleInfoSortField:%@, sortDirection:%@, page:%td, pageSize:%td}",
            [super description],
            self.advancedSearchInfo,
            self.contactRangeType,
            self.contactSimpleInfoSortField,
            self.sortDirection,
            self.page,
            self.pageSize];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAdvancedSearchVoRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.advancedSearchInfo = [[self.advancedSearchInfo copyWithZone:zone] autorelease];
            object.contactRangeType = [[self.contactRangeType copyWithZone:zone] autorelease];
            object.contactSimpleInfoSortField = [[self.contactSimpleInfoSortField copyWithZone:zone] autorelease];
            object.sortDirection = [[self.sortDirection copyWithZone:zone] autorelease];
            object.page = self.page;
            object.pageSize = self.pageSize;
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"contactRangetype":@"contactRangeType",
                                                              @"contactsimpleinfoSortField":@"contactSimpleInfoSortField",
                                                              @"sortDirection":@"sortDirection",
                                                              @"page":@"page",
                                                              @"pageSize":@"pageSize"
                                                              }];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"advancedSearchInfo"
                                                                                        toKeyPath:@"advancedSearchInfo"
                                                                                      withMapping:[WCTRCAdvancedSearchInfo responseMapping]]];
        

    }
    
    return responseMapping;
}
@end
