//
//  WCTRCAdvancedSearchInfo.m
//  ADAL
//
//  Created by sanhue on 2018/4/26.
//

#import "WCTRCAdvancedSearchInfo.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTRCAdvancedSearchInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountCondition release];
    _accountCondition = nil;
    
    [_categoryCondition release];
    _categoryCondition = nil;
    
    [_contactInfoCondition release];
    _contactInfoCondition = nil;
    
    [_customFieldCondition release];
    _customFieldCondition = nil;
    
    [_timeCondition release];
    _timeCondition = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountCondition:%@, categoryCondition:%@, contactInfoCondition:%@, customFieldCondition:%@, timeCondition:%@}",
            [super description],
            self.accountCondition,
            self.categoryCondition,
            self.contactInfoCondition,
            self.customFieldCondition,
            self.timeCondition];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAdvancedSearchInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountCondition = [[self.accountCondition copyWithZone:zone] autorelease];
            object.categoryCondition = [[self.categoryCondition copyWithZone:zone] autorelease];
            object.contactInfoCondition = [[self.contactInfoCondition copyWithZone:zone] autorelease];
            object.customFieldCondition = [[self.customFieldCondition copyWithZone:zone] autorelease];
            object.timeCondition = [[self.timeCondition copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {

        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"accountCondition"
                                                                                        toKeyPath:@"accountCondition"
                                                                                      withMapping:[WCTRCAdvancedSearchAccountCondition responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"categoryCondition"
                                                                                        toKeyPath:@"categoryCondition"
                                                                                      withMapping:[WCTRCAdvancedSearchCategoryCondition responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"contactInfoCondition"
                                                                                        toKeyPath:@"contactInfoCondition"
                                                                                      withMapping:[WCTRCAdvancedSearchContactInfoCondition responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"customFieldCondition"
                                                                                        toKeyPath:@"customFieldCondition"
                                                                                      withMapping:[WCTRCAdvancedSearchCustomFieldCondition responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"timeCondition"
                                                                                        toKeyPath:@"timeCondition"
                                                                                      withMapping:[WCTRCAdvancedSearchTimeCondition responseMapping]]];
        

    }
    
    return responseMapping;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - utility methods


//==============================================================================
//
//==============================================================================
- (void)addConditionWithFieldString:(NSString*)fieldString accountGuids:(NSArray *)accountGuids
{
    if([fieldString length]==0 ||
       [accountGuids count]==0)
    {
        return ;
    }
    
    NSAssert(([fieldString isEqualToString:WCTRC_AccountSearchField_Creator] ||
              [fieldString isEqualToString:WCTRC_AccountSearchField_Editor]||
              [fieldString isEqualToString:WCTRC_AccountSearchField_Owner]),
             @"輸入值不合法，請檢查程式碼 (只能是以下其中之一，WCTRC_AccountSearchField_Creator, WCTRC_AccountSearchField_Editor, WCTRC_AccountSearchField_Owner)");

    
    if (self.accountCondition==nil)
    {
        self.accountCondition = [[[WCTRCAdvancedSearchAccountCondition alloc] init] autorelease];
    }
    
    self.accountCondition.field = fieldString;
    self.accountCondition.accountGuids = accountGuids;
}


//==============================================================================
//
//==============================================================================
- (void)addConditionWithCategoryGuids:(NSArray *)categoryGuids
{
    if([categoryGuids count]==0)
    {
        return ;
    }

    if (self.categoryCondition==nil)
    {
        self.categoryCondition = [[[WCTRCAdvancedSearchCategoryCondition alloc] init] autorelease];
    }
    
    self.categoryCondition.categoryGuids = categoryGuids;
}


//==============================================================================
//
//==============================================================================
- (void)addConditionWithContactSearchInfo:(WCTRCAdvancedSearchContactSearchInfo *)contactSearchInfo;
{
    if (contactSearchInfo==nil)
    {
        return;
    }
    
    if (self.contactInfoCondition==nil)
    {
        self.contactInfoCondition = [[[WCTRCAdvancedSearchContactInfoCondition alloc] init] autorelease];
    }
    
    [self.contactInfoCondition.searchInfos addObject:contactSearchInfo];
}


//==============================================================================
//
//==============================================================================
- (void)addConditionWithCustomFieldSearchInfo:(WCTRCAdvancedSearchCustomFieldSearchInfo *)customFieldSearchInfo
{
    if (customFieldSearchInfo==nil)
    {
        return;
    }
    
    if (self.customFieldCondition==nil)
    {
        self.customFieldCondition = [[[WCTRCAdvancedSearchCustomFieldCondition alloc] init] autorelease];
    }
    
    [self.customFieldCondition.customFieldSearchInfos addObject:customFieldSearchInfo];
}


//==============================================================================
//
//==============================================================================
- (void)addConditionWithFieldString:(NSString*)fieldString beginTime:(NSString *)beginTime endTime:(NSString *)endTime
{
    if([fieldString length]==0)
    {
        return ;
    }
    
    NSAssert(([fieldString isEqualToString:WCTRC_TimeSearchField_CreateTime] ||
              [fieldString isEqualToString:WCTRC_TimeSearchField_ModifyTime]),
             @"輸入值不合法，請檢查程式碼 (只能是以下其中之一，WCTRC_TimeSearchField_CreateTime, WCTRC_TimeSearchField_ModifyTime)");

    NSAssert(([beginTime length]!=0 ||
              [endTime length]!=0),
             @"開始與結束時間，至少要有一個有值");

    
    if (self.timeCondition==nil)
    {
        self.timeCondition = [[[WCTRCAdvancedSearchTimeCondition alloc] init] autorelease];
    }
    
    self.timeCondition.field = fieldString;
    self.timeCondition.beginTime = beginTime;
    self.timeCondition.endTime = endTime;
    
}


@end
