//
//  WCTRCAdvancedSearchContactInfoCondition.m
//  ADAL
//
//  Created by sanhue on 2018/4/27.
//

#import "WCTRCAdvancedSearchContactInfoCondition.h"


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTRCAdvancedSearchContactInfoCondition ()

#pragma mark property
@property (nonatomic, retain, readwrite) NSMutableArray *searchInfos;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation WCTRCAdvancedSearchContactInfoCondition

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    self = [super init];
    
    if (self) {
        _searchInfos = [[NSMutableArray alloc] init];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_searchInfos release];
    _searchInfos = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{categoryGuids:%@}",
            [super description],
            self.searchInfos];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAdvancedSearchContactInfoCondition *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.searchInfos = [[self.searchInfos copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"searchinfos"
                                                                                        toKeyPath:@"searchInfos"
                                                                                      withMapping:[WCTRCAdvancedSearchContactSearchInfo responseMapping]]];
    }
    
    return responseMapping;
}
@end
