//
//  WCTRCAllRegistry.m
//
//
//  Created by Howard on 2018/7/23.
//

#import "WCTRCAllRegistry.h"

@implementation WCTRCAllRegistry

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dealloc Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.acdate = nil;
    self.cmd = nil;
    self.email = nil;
    self.hwid = nil;
    self.hwid2 = nil;
    self.snid = nil;
    self.updateTime = nil;
    self.validateDate = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{cmd:%@, email:%@, hwid:%@, hwid2:%@, isExpired:%d, isTrial:%d, liceseCount:%td, updateTime:%@, validateDate:%@}",
            [super description],
            self.cmd,
            self.email,
            self.hwid,
            self.hwid2,
            self.isExpired,
            self.isTrial,
            self.liceseCount,
            self.updateTime,
            self.validateDate];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAllRegistry *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.cmd = [[self.cmd copyWithZone:zone] autorelease];
            object.email = [[self.email copyWithZone:zone] autorelease];
            object.hwid = [[self.hwid copyWithZone:zone] autorelease];
            object.hwid2 = [[self.hwid2 copyWithZone:zone] autorelease];
            object.isExpired = self.isExpired;
            object.isTrial = self.isTrial;
            object.liceseCount = self.liceseCount;
            object.snid = [[self.snid copyWithZone:zone] autorelease];
            object.updateTime = [[self.updateTime copyWithZone:zone] autorelease];
            object.validateDate = [[self.validateDate copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"acdate":@"acdate",
                                                              @"cmd":@"cmd",
                                                              @"email":@"email",
                                                              @"hwid":@"hwid",
                                                              @"hwid2":@"hwid2",
                                                              @"isExpired":@"isExpired",
                                                              @"isTrial":@"isTrial",
                                                              @"liceseCount":@"liceseCount",
                                                              @"snid":@"snid",
                                                              @"updateTime":@"updateTime",
                                                              @"validateDate":@"validateDate"
                                                              }];
    }
    
    return responseMapping;
}

@end
