//
//  WCTRCContactSharedAccountsInfo.m
//  
//
//  Created by Howard on 2016/3/25.
//
//

#import "WCTRCContactSharedAccountsInfo.h"

@implementation WCTRCContactSharedAccountsInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountGuid release];
    _accountGuid = nil;

    [_accountName release];
    _accountName = nil;
    
    [_status release];
    _status = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountGuid:%@, accountName:%@, status:%@, beBoss:%@, beSubordinate:%@, SharedContactCount:%ld}",
            [super description],
            self.accountGuid,
            self.accountName,
            self.status,
            self.beBoss?@"YES":@"NO",
            self.beSubordinate?@"YES":@"NO",
            (long)self.sharedContactCount];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactSharedAccountsInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountName = [[self.accountName copyWithZone:zone] autorelease];
            object.accountGuid = [[self.accountGuid copyWithZone:zone] autorelease];
            object.status = [[self.status copyWithZone:zone] autorelease];
            object.beBoss = self.beBoss;
            object.beSubordinate = self.beSubordinate;
            object.sharedContactCount = self.sharedContactCount;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountName":@"accountName",
                                                              @"accountGuid":@"accountGuid",
                                                              @"status":@"status",
                                                              @"beBoss":@"beBoss",
                                                              @"beSubordinate":@"beSubordinate",
                                                              @"sharedContactCount":@"sharedContactCount"}];
    }
    
    return responseMapping;
}
@end
