//
//  WCTRCSharedContactsByAccountResponseResult.m
//  
//
//  Created by Howard on 2016/3/28.
//
//

#import "WCTRCContactListPageResponseResult.h"

@implementation WCTRCContactListPageResponseResult


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_errorData release];
    _errorData = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{errorData:%@, totalCount:%ld, totalPages:%ld}",
            [super description],
            self.errorData,
            (long)self.totalCount,
            (long)self.totalPages];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactListPageResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.errorData = [[self.errorData copyWithZone:zone] autorelease];
            object.totalCount = self.totalCount;
            object.totalPages = self.totalPages;
        }
    }
    
    return object;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"message":@"message",
                                                              @"errorData":@"errorData",
                                                              @"totalCount":@"totalCount",
                                                              @"totalPages":@"totalPages"}];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"data"
                                                                                        toKeyPath:@"data"
                                                                                      withMapping:[WCTRCContactSimpleInfo responseMapping]]];
        
    }
    
    return responseMapping;
}

@end
