//
//  WCTNoticeListPageResponseResult.m
//  Pods
//
//  Created by sanhue on 2016/9/2.
//
//

#import "WCTRCNoticeListPageResponseResult.h"

@implementation WCTRCNoticeListPageResponseResult


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_data release];
    _data = nil;
    
    [_message release];
    _message = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{data:%@, message:%@, totalCount:%ld, totalPages:%ld}",
            [super description],
            self.data,
            self.message,
            (long)self.totalCount,
            (long)self.totalPages];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCNoticeListPageResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.data = [[self.data copyWithZone:zone] autorelease];
            object.message = [[self.message copyWithZone:zone] autorelease];
            object.totalCount = self.totalCount;
            object.totalPages = self.totalPages;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"message":@"message",
                                                              @"totalCount":@"totalCount",
                                                              @"totalPages":@"totalPages"}];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"data"
                                                                                        toKeyPath:@"data"
                                                                                      withMapping:[WCTRCNoticeInfo responseMapping]]];
        
    }
    
    return responseMapping;
}

@end
