//
//  WCTRCCRMExportInfo.m
//  Pods
//
//  Created by sanhue on 2016/9/5.
//
//

#import "WCTRCUserExportInfo.h"

@implementation WCTRCUserExportInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_lastExportTime release];
    _lastExportTime = nil;
    
    [_lastExportResultJSON release];
    _lastExportResultJSON = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{lastExportCount:%ld, lastExportTime:%@, lastExportResultJSON:%@}",
            [super description],
            (long)self.lastExportCount,
            self.lastExportTime,
            self.lastExportResultJSON
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCUserExportInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.lastExportCount = self.lastExportCount;
            object.lastExportTime = [[self.lastExportTime copyWithZone:zone] autorelease];
            object.lastExportResultJSON = [[self.lastExportResultJSON copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"lastExportCount":@"lastExportCount",
                                                              @"lastExportTime":@"lastExportTime",
                                                              @"lastExportResultJSON":@"lastExportResultJSON"}];
    }
    
    return responseMapping;
}
@end
