//
//  WCTRCUpdateCRMTokenRequest.m
//  Pods
//
//  Created by sanhue on 2016/10/14.
//
//

#import "WCTRCUpdateCRMTokenRequest.h"

@implementation WCTRCUpdateCRMTokenRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_crmexportMode release];
    _crmexportMode = nil;
    
    [_salesforceUserAgentAuthToken release];
    _salesforceUserAgentAuthToken = nil;
    
    [_userCRMAccount release];
    _userCRMAccount = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{userCRMAccount:%@, crmexportMode:%@, salesforceUserAgentAuthToken:%@}",
            [super description],
            self.crmexportMode,
            self.salesforceUserAgentAuthToken,
            self.userCRMAccount
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCUpdateCRMTokenRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.crmexportMode = [[self.crmexportMode copyWithZone:zone] autorelease];
            object.salesforceUserAgentAuthToken = [[self.salesforceUserAgentAuthToken copyWithZone:zone] autorelease];
            object.userCRMAccount = [[self.userCRMAccount copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"crmexportMode":@"crmexportMode",
                                                              @"userCRMAccount":@"userCRMAccount"}];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"salesforceUserAgentAuthToken"
                                                                                        toKeyPath:@"salesforceUserAgentAuthToken"
                                                                                      withMapping:[WCTRCSalesforceUserAgentAuthToken responseMapping]]];

    }
    
    return responseMapping;
}
@end
