//
//  WCTRCSalesforceUserAgentAuthToken.m
//  Pods
//
//  Created by sanhue on 2016/10/14.
//
//

#import "WCTRCSalesforceUserAgentAuthToken.h"

@implementation WCTRCSalesforceUserAgentAuthToken

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_access_token release];
    _access_token = nil;
    
    [_identifier release];
    _identifier = nil;
    
    [_instance_url release];
    _instance_url = nil;
    
    [_issued_at release];
    _issued_at = nil;
    
    [_refresh_token release];
    _refresh_token = nil;
    
    [_signature release];
    _signature = nil;
    
    [_token_type release];
    _token_type = nil;

    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{access_token:%@, identifier:%@, instance_url:%@, issued_at:%@, refresh_token:%@, signature:%@, token_type:%@}",
            [super description],
            self.access_token,
            self.identifier,
            self.instance_url,
            self.issued_at,
            self.refresh_token,
            self.signature,
            self.token_type
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCSalesforceUserAgentAuthToken *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.access_token = [[self.access_token copyWithZone:zone] autorelease];
            object.identifier = [[self.identifier copyWithZone:zone] autorelease];
            object.instance_url = [[self.instance_url copyWithZone:zone] autorelease];
            object.issued_at = [[self.issued_at copyWithZone:zone] autorelease];
            object.refresh_token = [[self.refresh_token copyWithZone:zone] autorelease];
            object.signature = [[self.signature copyWithZone:zone] autorelease];
            object.token_type = [[self.token_type copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"access_token":@"access_token",
                                                              @"id":@"identifier",
                                                              @"instance_url":@"instance_url",
                                                              @"issued_at":@"issued_at",
                                                              @"refresh_token":@"refresh_token",
                                                              @"signature":@"signature",
                                                              @"token_type":@"token_type"}];
    }
    
    return responseMapping;
}
@end
