//
//  WCTRCQContactzSecurityInfo.m
//  WCTRestClientController
//
//  Created by Howard on 2020/9/28.
//

#import "WCTRCQContactzSecurityInfo.h"

@implementation WCTRCQContactzSecurityInfo


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.anotherVerification = nil;
    self.securityQuestionText = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{

    return [NSString stringWithFormat:@"%@{account:%@, authPassed:%d, emergencyCount:%td, emergencyLimit:%td, securityQuestionText:%@}",
            [super description],
            self.anotherVerification,
            self.authPassed,
            self.emergencyCount,
            self.emergencyLimit,
            self.securityQuestionText];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCQContactzSecurityInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.anotherVerification = [[self.anotherVerification copyWithZone:zone] autorelease];
            object.authPassed = self.authPassed;
            object.emergencyCount = self.emergencyCount;
            object.emergencyLimit = self.emergencyLimit;
            object.securityQuestionText = [[self.securityQuestionText copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:
         @{@"anotherVerification":@"anotherVerification",
           @"authPassed":@"authPassed",
           @"emergencyCount":@"emergencyCount",
           @"emergencyLimit":@"emergencyLimit",
           @"securityQuestionText":@"securityQuestionText"
        }];
    }
    
    return responseMapping;
}
@end
