//
//  WCTRCContactServerSystemDetail.m
//  WCTRestClientController
//
//  Created by sanhue on 2019/11/26.
//

#import "WCTRCExchangeServerSystemDetail.h"

@implementation WCTRCExchangeServerSystemDetail

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_supportContactServer release];
    _supportContactServer = nil;
    
    [_url release];
    _url = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{supportContactServer:%@, url:%@}",
            [super description],
            self.supportContactServer,
            self.url
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCExchangeServerSystemDetail *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.supportContactServer = [[self.supportContactServer copyWithZone:zone] autorelease];
            object.url = [[self.url copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"supportContactServer":@"supportContactServer",
                                                              @"url":@"url"}];
    }
    
    return responseMapping;
}
@end
