//
//  WCTRCContactServerSettings.m
//  ADAL
//
//  Created by sanhue on 2019/11/26.
//

#import "WCTRCExchangeServerSettings.h"

@implementation WCTRCExchangeServerSettings

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_account release];
    _account = nil;
    
    [_contactServerExportMode release];
    _contactServerExportMode = nil;
    
    [_password release];
    _password = nil;

    [_supportContactServer release];
    _supportContactServer = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{account:%@, contactServerExportMode:%@, password:%@, supportContactServer:%@}",
            [super description],
            self.account,
            self.contactServerExportMode,
            self.password,
            self.supportContactServer
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCExchangeServerSettings *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.account = [[self.account copyWithZone:zone] autorelease];
            object.contactServerExportMode = [[self.contactServerExportMode copyWithZone:zone] autorelease];
            object.password = [[self.password copyWithZone:zone] autorelease];
            object.supportContactServer = [[self.supportContactServer copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"account":@"account",
                                                              @"contactServerExportMode":@"contactServerExportMode",
                                                              @"password":@"password",
                                                              @"supportContactServer":@"supportContactServer"}];
    }
    
    return responseMapping;
}

@end
