//
//  WCTRCCustomFieldInfo.m
//  Pods
//
//  Created by sanhue on 2016/10/24.
//
//

#import "WCTRCCustomFieldInfo.h"

@implementation WCTRCCustomFieldInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_customFieldCategory release];
    _customFieldCategory = nil;
    
    [_customFieldContactAttribute release];
    _customFieldContactAttribute = nil;
    
    [_customFieldContents release];
    _customFieldContents = nil;
    
    [_customFieldName release];
    _customFieldName = nil;
    
    [_guid release];
    _guid = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{customFieldCategory:%@, customFieldContactAttribute:%@, customFieldContents:%@, customFieldName:%@, guid:%@}",
            [super description],
            self.customFieldCategory,
            self.customFieldContactAttribute,
            self.customFieldContents,
            self.customFieldName,
            self.guid];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCustomFieldInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.customFieldCategory = [[self.customFieldCategory copyWithZone:zone] autorelease];
            object.customFieldContactAttribute = [[self.customFieldContactAttribute copyWithZone:zone] autorelease];
            object.customFieldContents = [[self.customFieldContents copyWithZone:zone] autorelease];
            object.customFieldName = [[self.customFieldName copyWithZone:zone] autorelease];
            object.guid = [[self.guid copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"customFieldCategory":@"customFieldCategory",
                                                              @"customFieldContactAttribute":@"customFieldContactAttribute",
                                                              @"customFieldName":@"customFieldName",
                                                              @"guid":@"guid"}];
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"picklistContents"
                                                                                        toKeyPath:@"customFieldContents"
                                                                                      withMapping:[WCTRCCustomFieldContent responseMapping]]];

    }
    
    return responseMapping;
}


@end
