//
//  WCTRCCustomFieldContent.m
//  Pods
//
//  Created by sanhue on 2016/10/24.
//
//

#import "WCTRCCustomFieldContent.h"

@implementation WCTRCCustomFieldContent

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_guid release];
    _guid = nil;
    
    [_content release];
    _content = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{guid :%@, content:%@}",
            [super description],
            self.guid,
            self.content];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCustomFieldContent *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.content = [[self.content copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"guid":@"guid",
                                                              @"content":@"content"}];
    }
    
    return responseMapping;
}



@end
