//
//  WCTRCCRMSettings.m
//  Pods
//
//  Created by sanhue on 2016/9/5.
//
//

#import "WCTRCCRMSettings.h"

@implementation WCTRCCRMSettings

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_userCRMAccount release];
    _userCRMAccount = nil;
    
    [_userCRMExportMode release];
    _userCRMExportMode = nil;
    
    [_userCRMPassword release];
    _userCRMPassword = nil;
    
    [_userCRMSecretToken release];
    _userCRMSecretToken = nil;
    
    [_userStoredCRMType release];
    _userStoredCRMType = nil;

    self.companyAssignmentOption = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{userCRMAccount:%@, userCRMExportMode:%@, userCRMPassword:%@, userCRMSecretToken:%@, userStoredCRMType:%@, companyAssignmentOption:%@}",
            [super description],
            self.userCRMAccount,
            self.userCRMExportMode,
            self.userCRMPassword,
            self.userCRMSecretToken,
            self.userStoredCRMType,
            self.companyAssignmentOption
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCRMSettings *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.userCRMAccount = [[self.userCRMAccount copyWithZone:zone] autorelease];
            object.userCRMExportMode = [[self.userCRMExportMode copyWithZone:zone] autorelease];
            object.userCRMPassword = [[self.userCRMPassword copyWithZone:zone] autorelease];
            object.userCRMSecretToken = [[self.userCRMSecretToken copyWithZone:zone] autorelease];
            object.userStoredCRMType = [[self.userStoredCRMType copyWithZone:zone] autorelease];
            object.companyAssignmentOption = [[self.companyAssignmentOption copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"userCRMAccount":@"userCRMAccount",
                                                              @"userCRMExportMode":@"userCRMExportMode",
                                                              @"userCRMPassword":@"userCRMPassword",
                                                              @"userCRMSecretToken":@"userCRMSecretToken",
                                                              @"userStoredCRMType":@"userStoredCRMType",@"companyAssignmentOption":@"companyAssignmentOption"}];
    }
    
    return responseMapping;
}

@end
