//
//  WCTRCAllUserSettingsResponseResult.m
//  Pods
//
//  Created by sanhue on 2016/5/25.
//
//

#import "WCTRCAllUserSettingsResponseResult.h"

@implementation WCTRCAllUserSettingsResponseResult

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_data release];
    _data = nil;
    
    [_message release];
    _message = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{data:%@, message:%@}",
            [super description],
            self.data,
            self.message];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAllUserSettingsResponseResult *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.data = [[self.data copyWithZone:zone] autorelease];
            object.message = [[self.message copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"message":@"message"}];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"data"
                                                                                        toKeyPath:@"data"
                                                                                      withMapping:[WCTRCAccountPrivateSettings responseMapping]]];
        
    }
    
    return responseMapping;
}
@end
