//
//  WCTRCAccountSharedTargetListRequest.m
//  Pods
//
//  Created by sanhue on 2016/5/18.
//
//

#import "WCTRCAccountSharedTargetListRequest.h"
#import "WCTRCAccountSharedTarget.h"

@implementation WCTRCAccountSharedTargetListRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountGuids release];
    _accountGuids = nil;
    
    [_shareItem release];
    _shareItem = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@\n{accountGuids:%@, shareItem:%@}",
            [super description],
            self.accountGuids,
            self.shareItem];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAccountSharedTargetListRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountGuids = [[self.accountGuids copyWithZone:zone] autorelease];
            object.shareItem = [[self.shareItem copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountGuids":@"accountGuids",
                                                              @"shareItem":@"shareItem"}];
    }
    
    return responseMapping;
}

@end
