//
//  WCTRCAccountSharedTarget.m
//  Pods
//
//  Created by sanhue on 2016/5/12.
//
//

#import "WCTRCAccountSharedTarget.h"

@implementation WCTRCAccountSharedTarget

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountGuid release];
    _accountGuid = nil;
    
    [_accountName release];
    _accountName = nil;
    
    [_shareItem release];
    _shareItem = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountGuid:%@, accountName:%@, isBoss:%@, isSubordinate:%@, shareItem:%@,}",
            [super description],
            self.accountGuid,
            self.accountName,
            self.boss?@"YES":@"NO",
            self.subordinate?@"YES":@"NO",
            self.shareItem
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAccountSharedTarget *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountGuid = [[self.accountGuid copyWithZone:zone] autorelease];
            object.accountName = [[self.accountName copyWithZone:zone] autorelease];
            object.boss = self.boss;
            object.subordinate = self.subordinate;
            object.shareItem = [[self.shareItem copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountGuid":@"accountGuid",
                                                              @"accountName":@"accountName",
                                                              @"boss":@"boss",
                                                              @"subordinate":@"subordinate",
                                                              @"shareItem":@"shareItem"}];
    }
    
    return responseMapping;
}

@end
