//
//  WCTRCAccountPrivateSettings.m
//  Pods
//
//  Created by sanhue on 2016/5/25.
//
//

#import "WCTRCAccountPrivateSettings.h"
#import "WCTRCAccountSharedTarget.h"

@implementation WCTRCAccountPrivateSettings

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_activityShareTargets release];
    _activityShareTargets = nil;

    [_asianSurnameOrder release];
    _asianSurnameOrder = nil;
 
    [_contactShareTargets release];
    _contactShareTargets = nil;

    [_crmUrl release];
    _crmUrl = nil;
    
    [_globalShareRule release];
    _globalShareRule = nil;
    
    [_identificationResult release];
    _identificationResult = nil;
    
    [_lastExportCount release];
    _lastExportCount = nil;

    [_lastExportTime release];
    _lastExportTime = nil;

    [_mapEngine release];
    _mapEngine = nil;
    
    [_modifyTime release];
    _modifyTime = nil;
    
    [_sortingOrder release];
    _sortingOrder = nil;
    
    [_taskShareTargets release];
    _taskShareTargets = nil;

    [_userCRMAccount release];
    _userCRMAccount = nil;
    
    [_userCRMExportMode release];
    _userCRMExportMode = nil;
    
    [_userCRMPassword release];
    _userCRMPassword = nil;
    
    [_userCRMSecretToken release];
    _userCRMSecretToken = nil;
    
    [_userStoredCRMType release];
    _userStoredCRMType = nil;

    [_userContactServerAccount release];
    _userContactServerAccount = nil;

    [_userContactServerExportMode release];
    _userContactServerExportMode = nil;

    [_userStoredContactServerType release];
    _userStoredContactServerType = nil;

    [_westernSurnameOrder release];
    _westernSurnameOrder = nil;
    
    self.crmCompanyAssignmentOption = nil;
    
    [_pcsSupportedLangs release];
    _pcsSupportedLangs = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{asianSurnameOrder:%@, addNoteInfoAfterRecog:%@, editAfterRecog:%@, crmUrl:%@, \
            globalShareRule:%@, identificationResult:%@, \
            lastExportCount:%@, lastExportTime:%@, mapEngine:%@, modifyTime:%@, \
            sortingOrder:%@, autoShareToAll:%@, westernSurnameOrder:%@, \
            userCRMAccount:%@, userCRMExportMode:%@, userCRMPassword:%@,  userCRMSecretToken:%@, userStoredCRMType:%@, \
            userContactServerAccount:%@, userContactServerExportMode:%@,userStoredContactServerType:%@,\n  \
            - activityShareTargets:%@\n  - contactShareTargets:%@\n  - taskShareTargets:%@\n, crmCompanyAssignmentOption:%@, pcsSupportedLangs:%@}",
            [super description],
            self.asianSurnameOrder,
            self.addNoteInfoAfterRecog?@"YES":@"NO",
            self.editAfterRecog?@"YES":@"NO",
            self.crmUrl,
            self.globalShareRule,
            self.identificationResult,
            self.lastExportCount,
            self.lastExportTime,
            self.mapEngine,
            self.modifyTime,
            self.sortingOrder,
            self.autoShare?@"YES":@"NO",
            self.westernSurnameOrder,
            self.userCRMAccount,
            self.userCRMExportMode,
            self.userCRMPassword,
            self.userCRMSecretToken,
            self.userStoredCRMType,
            self.userContactServerAccount,
            self.userContactServerExportMode,
            self.userStoredContactServerType,
            self.activityShareTargets,
            self.contactShareTargets,
            self.taskShareTargets,
            self.crmCompanyAssignmentOption,
            self.pcsSupportedLangs
            ];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAccountPrivateSettings *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.activityShareTargets = [[self.activityShareTargets copyWithZone:zone] autorelease];
            object.asianSurnameOrder = [[self.asianSurnameOrder copyWithZone:zone] autorelease];
            object.addNoteInfoAfterRecog = self.addNoteInfoAfterRecog;
            object.editAfterRecog = self.editAfterRecog;
            object.autoShare = self.autoShare;
            object.contactShareTargets = [[self.contactShareTargets copyWithZone:zone] autorelease];
            object.crmUrl = [[self.crmUrl copyWithZone:zone] autorelease];
            object.globalShareRule = [[self.globalShareRule copyWithZone:zone] autorelease];
            object.identificationResult = [[self.identificationResult copyWithZone:zone] autorelease];
            object.lastExportCount = [[self.lastExportCount copyWithZone:zone] autorelease];
            object.lastExportTime = [[self.lastExportTime copyWithZone:zone] autorelease];
            object.mapEngine = [[self.mapEngine copyWithZone:zone] autorelease];
            object.modifyTime = [[self.modifyTime copyWithZone:zone] autorelease];
            object.sortingOrder = [[self.sortingOrder copyWithZone:zone] autorelease];
            object.taskShareTargets = [[self.taskShareTargets copyWithZone:zone] autorelease];
            object.userCRMAccount = [[self.userCRMAccount copyWithZone:zone] autorelease];
            object.userCRMExportMode = [[self.userCRMExportMode copyWithZone:zone] autorelease];
            object.userCRMPassword = [[self.userCRMPassword copyWithZone:zone] autorelease];
            object.userCRMSecretToken = [[self.userCRMSecretToken copyWithZone:zone] autorelease];
            object.userStoredCRMType = [[self.userStoredCRMType copyWithZone:zone] autorelease];
            object.userContactServerAccount = [[self.userContactServerAccount copyWithZone:zone] autorelease];
            object.userContactServerExportMode = [[self.userContactServerExportMode copyWithZone:zone] autorelease];
            object.userStoredContactServerType = [[self.userStoredContactServerType copyWithZone:zone] autorelease];
            object.westernSurnameOrder = [[self.westernSurnameOrder copyWithZone:zone] autorelease];
            object.crmCompanyAssignmentOption = [[self.crmCompanyAssignmentOption copyWithZone:zone] autorelease];
            object.pcsSupportedLangs = [[self.pcsSupportedLangs copyWithZone:zone] autorelease];
            
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"asianSurnameOrder":@"asianSurnameOrder",
                                                              @"addnoteinfoAfterRecog":@"addNoteInfoAfterRecog",
                                                              @"editAfterRecog":@"editAfterRecog",
                                                              @"autoShare":@"autoShare",
                                                              @"crmUrl":@"crmUrl",
                                                              @"globalShareRule":@"globalShareRule",
                                                              @"identificationResult":@"identificationResult",
                                                              @"lastexportcount":@"lastExportCount",
                                                              @"lastexportcime":@"lastExportTime",
                                                              @"mapEngine":@"mapEngine",
                                                              @"modifytime":@"modifyTime",
                                                              @"sortingOrder":@"sortingOrder",
                                                              @"userCRMAccount":@"userCRMAccount",
                                                              @"userCRMExportMode":@"userCRMExportMode",
                                                              @"userCRMPassword":@"userCRMPassword",
                                                              @"userCRMSecretToken":@"userCRMSecretToken",
                                                              @"userStoredCRMType":@"userStoredCRMType",
                                                              @"userContactServerAccount":@"userContactServerAccount",
                                                              @"userContactServerExportMode":@"userContactServerExportMode",
                                                              @"userStoredContactServerType":@"userStoredContactServerType",
                                                              @"westernSurnameOrder":@"westernSurnameOrder",
                                                              @"crmCompanyAssignmentOption":@"crmCompanyAssignmentOption",
                                                              @"pcsSupportedLangs":@"pcsSupportedLangs"
        }];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"activityShareTargets"
                                                                                        toKeyPath:@"activityShareTargets"
                                                                                      withMapping:[WCTRCAccountSharedTarget responseMapping]]];

        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"contactShareTargets"
                                                                                        toKeyPath:@"contactShareTargets"
                                                                                      withMapping:[WCTRCAccountSharedTarget responseMapping]]];

        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"taskShareTargets"
                                                                                        toKeyPath:@"taskShareTargets"
                                                                                      withMapping:[WCTRCAccountSharedTarget responseMapping]]];

    }
    
    return responseMapping;
}
@end
