//
//  WCTRCMyCardInfoToUpdate.m
//  WCTRestClientController
//
//  Created by sanhue cheng on 2020/10/26.
//

#import "WCTRCUpdateMyCardInfoRequest.h"

@implementation WCTRCUpdateMyCardInfoRequest





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_frontImageBase64 release];
    _frontImageBase64 = nil;
    
    [_rearImageBase64 release];
    _rearImageBase64 = nil;
    
    [_logoImageBase64 release];
    _logoImageBase64 = nil;
    
    [_updateComponents release];
    _updateComponents = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{frontImageBase64:%@, rearImageBase64:%@, logoImageBase64:%@, updateComponents:%@}",
            [super description],
            self.frontImageBase64,
            self.rearImageBase64,
            self.logoImageBase64,
            self.updateComponents];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCUpdateMyCardInfoRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.frontImageBase64 = [[self.frontImageBase64 copyWithZone:zone] autorelease];
            object.rearImageBase64 = [[self.rearImageBase64 copyWithZone:zone] autorelease];
            object.logoImageBase64 = [[self.logoImageBase64 copyWithZone:zone] autorelease];
            object.updateComponents = [[self.updateComponents copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"frontImageBase64":@"frontImageBase64",
                                                              @"rearImageBase64":@"rearImageBase64",
                                                              @"logoImageBase64":@"logoImageBase64",
                                                              @"updateComponents":@"updateComponents"
        }];
    }
    
    return responseMapping;
}
@end
