//
//  WCTRCMLCategoryPathCreationRequest.m
//  
//
//  Created by Howard on 2018/4/23.
//

#import "WCTRCMLCategoryPathCreationRequest.h"

@implementation WCTRCMLCategoryPathCreationRequest


#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_categoryPath release];
    _categoryPath = nil;
    
    [_ownerAccountGuid release];
    _ownerAccountGuid = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{categoryPath:%@, ownerAccountGuid:%@}",
            [super description],
            self.categoryPath,
            self.ownerAccountGuid];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCMLCategoryPathCreationRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.categoryPath = [[self.categoryPath copyWithZone:zone] autorelease];
            object.ownerAccountGuid = [[self.ownerAccountGuid copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"categoryPath":@"categoryPath",
                                                              @"ownerAccountGuid":@"ownerAccountGuid"
                                                              }];
        
    }
    
    return responseMapping;
}


@end
