//
//  WCTRCCategoryInfoMultiLayer.m
//  
//
//  Created by Howard on 2018/2/13.
//

#import "WCTRCCategoryInfoMultiLayer.h"

@implementation WCTRCCategoryInfoMultiLayer

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_categoryType release];
    _categoryType = nil;
    
    [_guid release];
    _guid = nil;
    
    [_name release];
    _name = nil;
    
    [_parentCategoryGuid release];
    _parentCategoryGuid = nil;
    
    [_secretaryAccountGuid release];
    _secretaryAccountGuid = nil;
    
    [_updateTime release];
    _updateTime = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{categoryType:%@, guid:%@, hasChildren:%d, name:%@, parentCategoryGuid:%@, secretaryAccountGuid:%@, updateTime:%@, isToggled:%d}",
            [super description],
            self.categoryType,
            self.guid,
            self.hasChildren,
            self.name,
            self.parentCategoryGuid,
            self.secretaryAccountGuid,
            self.updateTime,
            self.isToggled];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCategoryInfoMultiLayer *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.categoryType = [[self.categoryType copyWithZone:zone] autorelease];
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.hasChildren = self.hasChildren;
            object.name = [[self.name copyWithZone:zone] autorelease];
            object.parentCategoryGuid = [[self.parentCategoryGuid copyWithZone:zone] autorelease];
            object.secretaryAccountGuid = [[self.secretaryAccountGuid copyWithZone:zone] autorelease];
            object.updateTime = [[self.updateTime copyWithZone:zone] autorelease];
            object.isToggled = self.isToggled;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"categoryType":@"categoryType",
                                                              @"guid":@"guid",
                                                              @"hasChildren":@"hasChildren",
                                                              @"name":@"name",
                                                              @"parentCategoryGuid":@"parentCategoryGuid",
                                                              @"secretaryAccountGuid":@"secretaryAccountGuid",
                                                              @"updateTime":@"updateTime",
                                                              @"isToggled":@"isToggled"
                                                              }];
        
    }
    
    return responseMapping;
}


@end
