//
//  WCTRCTokenInfo.m
//  
//
//  Created by Howard on 2016/3/9.
//  Copyright © 2016年 penpower. All rights reserved.
//

#import "WCTRCTokenInfo.h"

@implementation WCTRCTokenInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_createTime release];
    _createTime = nil;
    
    [_expiredTime release];
    _expiredTime = nil;
    
    [_invalidTime release];
    _invalidTime = nil;
    
    [_token release];
    _token = nil;
    
    [_platform release];
    _platform = nil;
    
    [_platformCategory release];
    _platformCategory = nil;
    
    [_ip release];
    _ip = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{createTime:%@, expiredTime:%@, invalidTime:%@, token:%@, platform:%@, platformCategory:%@, ip:%@}",
            [super description],
            self.createTime,
            self.expiredTime,
            self.invalidTime,
            self.token,
            self.platform,
            self.platformCategory,
            self.ip];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCTokenInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.createTime = [[self.createTime copyWithZone:zone] autorelease];
            object.expiredTime = [[self.expiredTime copyWithZone:zone] autorelease];
            object.invalidTime = [[self.invalidTime copyWithZone:zone] autorelease];
            
            object.token = [[self.token copyWithZone:zone] autorelease];
            object.platform = [[self.platform copyWithZone:zone] autorelease];
            object.platformCategory = [[self.platformCategory copyWithZone:zone] autorelease];
            object.ip = [[self.ip copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"createTime" : @"createTime",
                                                              @"expiredTime" : @"expiredTime",
                                                              @"invalidTime" : @"invalidTime",
                                                              @"token" : @"token",
                                                              @"platform" : @"platform",
                                                              @"platformCategory" : @"platformCategory",
                                                              @"ip" : @"ip"
                                                              }];
    }
    
    return responseMapping;
}
@end
