//
//  WCTRCLoginRequestObject.m
//  
//
//  Created by Howard on 2016/3/9.
//  Copyright © 2016年 penpower. All rights reserved.
//

#import "WCTRCLoginRequestObject.h"


@implementation WCTRCLoginRequestObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        _clientLocalTime = [[NSDate date] retain];
 
        _deviceId = [[[self class] systemUUID] retain];
        
#if TARGET_OS_IPHONE
        
        _deviceName = [[[UIDevice currentDevice] name] retain];
        
#elif TARGET_OS_OSX
        
        _deviceName = [[[NSHost currentHost] localizedName] retain];
        
#endif
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_email release];
    _email = nil;
    
    [_password release];
    _password = nil;

    [_clientLocalTime release];
    _clientLocalTime = nil;
    
    [_platform release];
    _platform = nil;
    
    [_deviceId release];
    [_deviceName release];
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{email:%@, deviceId:%@, deviceName:%@, password:%@, clientLocalTime:%@, platform:%@}",
            [super description],
            self.email,
            self.deviceId,
            self.deviceName,
            self.password,
            self.clientLocalTime,
            self.platform];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCLoginRequestObject *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.email = [[self.email copyWithZone:zone] autorelease];
            object.password = [[self.password copyWithZone:zone] autorelease];
            object.clientLocalTime = [[self.clientLocalTime copyWithZone:zone] autorelease];
            object.platform = [[self.platform copyWithZone:zone] autorelease];
            object.deviceId = [[self.deviceId copyWithZone:zone] autorelease];
            object.deviceName = [[self.deviceName copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"email":@"email",
                                                              @"password":@"password",
                                                              @"clientLocalTime":@"clientLocalTime",
                                                              @"platform":@"platform",
                                                              @"deviceId":@"deviceId",        @"deviceName":@"deviceName"
                                                              }];
    }
    
    return responseMapping;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - private

//==============================================================================
//
//==============================================================================
+ (NSString *)systemUUID
{
#if TARGET_OS_IPHONE
    
    UIDevice *currentDevice      = [UIDevice currentDevice];
    if([currentDevice respondsToSelector:@selector(identifierForVendor)])
    {
        return [[[UIDevice currentDevice] identifierForVendor] UUIDString];
    }
    
    return nil;
    
#elif TARGET_OS_OSX
    
    io_service_t platformExpert = IOServiceGetMatchingService(kIOMasterPortDefault,IOServiceMatching("IOPlatformExpertDevice"));
    if (!platformExpert)
        return nil;
    
    CFTypeRef serialNumberAsCFString = IORegistryEntryCreateCFProperty(platformExpert,CFSTR(kIOPlatformUUIDKey),kCFAllocatorDefault, 0);
    IOObjectRelease(platformExpert);
    
    if (!serialNumberAsCFString)
        return nil;
    
    NSString *uuid = [NSString stringWithString:(__bridge NSString *)(serialNumberAsCFString)];
    CFRelease(serialNumberAsCFString);
    return uuid;
    
#endif
    
}

@end
