//
//  WCTRCLoginInfo.m
//
//
//  Created by Howard on 2016/3/9.
//  Copyright © 2016年 penpower. All rights reserved.
//

#import "WCTRCLoginInfo.h"

@implementation WCTRCLoginInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountInfo release];
    _accountInfo = nil;
    
    [_databaseCreateTime release];
    _databaseCreateTime = nil;
    
    [_serverId release];
    _serverId = nil;
    
    [_serverStatus release];
    _serverStatus = nil;
    
    [_serverVersion release];
    _serverVersion = nil;
    
    [_tokenInfo release];
    _tokenInfo = nil;
    
    [_serverTime release];
    _serverTime = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountInfo:%@, databaseCreateTime:%@, serverId:%@, serverStatus:%@, serverVersion:%@, serverTime:%@, tokenInfo:%@, isNeedChangePassword:%@}",
            [super description],
            self.accountInfo,
            self.databaseCreateTime,
            self.serverId,
            self.serverStatus,
            self.serverVersion,
            self.serverTime,
            self.tokenInfo,
            self.isNeedChangePassword?@"YES":@"NO"];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCLoginInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountInfo = [[self.accountInfo copyWithZone:zone] autorelease];
            object.databaseCreateTime = [[self.databaseCreateTime copyWithZone:zone] autorelease];
            object.serverId = [[self.serverId copyWithZone:zone] autorelease];
            object.serverStatus = [[self.serverStatus copyWithZone:zone] autorelease];
            object.serverVersion = [[self.serverVersion copyWithZone:zone] autorelease];
            object.serverTime = [[self.serverTime copyWithZone:zone] autorelease];
            object.tokenInfo = [[self.tokenInfo copyWithZone:zone] autorelease];
            object.isNeedChangePassword = self.isNeedChangePassword;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"serverId":@"serverId",
                                                              @"databaseCreateTime":@"databaseCreateTime",
                                                              @"serverVersion":@"serverVersion",
                                                              @"serverTime":@"serverTime",
                                                              @"isNeedChangePassword":@"isNeedChangePassword"}];

        //////////////////////////////////////////////////

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"serverStatus"
                                                                                        toKeyPath:@"serverStatus"
                                                                                      withMapping:[WCTRCServerStatus responseMapping]]];

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"accountInfo"
                                                                                        toKeyPath:@"accountInfo"
                                                                                      withMapping:[WCTRCAccountInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"tokenInfo"
                                                                                        toKeyPath:@"tokenInfo"
                                                                                      withMapping:[WCTRCTokenInfo responseMapping]]];

    }
    
    return responseMapping;
}
@end
