//
//  WCTRCAccountInfo.m
//
//
//  Created by Howard on 2016/3/9.
//  Copyright © 2016年 penpower. All rights reserved.
//

#import "WCTRCAccountInfo.h"

@implementation WCTRCAccountInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountSubscriptionStatus release];
    _accountSubscriptionStatus = nil;
    
    [_accountType release];
    _accountType = nil;
    
    [_activeDirectoryAccountMail release];
    _activeDirectoryAccountMail = nil;
    
    [_activeDirectoryBaseDn release];
    _activeDirectoryBaseDn = nil;
    
    [_activeDirectoryServer release];
    _activeDirectoryServer = nil;
    
    [_boss release];
    _boss = nil;
    
    [_createDate release];
    _createDate = nil;
    
    [_email release];
    _email = nil;
    
    [_guid release];
    _guid = nil;
    
    [_inheritanceStatus release];
    _inheritanceStatus = nil;
    
    [_name release];
    _name = nil;
    
    [_role release];
    _role = nil;
    
    [_status release];
    _status = nil;
    
    [_companyGuid release];
    _companyGuid = nil;
    
    [_lastPasswordChangeTime release];
    _lastPasswordChangeTime = nil;
    
    [_lockedIssue release];
    _lockedIssue = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountSubscriptionStatus: %@, accountType:%@, activeDirectoryAccountMail:%@, activeDirectoryBaseDn:%@, activeDirectoryServer:%@, boss:%@, createDate:%@, email:%@, exportAblility:%d, guid:%@, inheritanceStatus:%@, name:%@, printAbility:%d, role:%@, secretary:%d, status:%@\n==================\n compnayGuid:%@,\nlastChangePasswordTime:%@,\nLockedIssue:%@}",
            [super description],
            self.accountSubscriptionStatus,
            self.accountType,
            self.activeDirectoryAccountMail,
            self.activeDirectoryBaseDn,
            self.activeDirectoryServer,
            self.boss,
            self.createDate,
            self.email,
            self.exportAbility,
            self.guid,
            self.inheritanceStatus,
            self.name,
            self.printAbility,
            self.role,
            self.secretary,
            self.status,
            self.companyGuid,
            self.lastPasswordChangeTime,
            self.lockedIssue];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCAccountInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountSubscriptionStatus = [[self.accountSubscriptionStatus copyWithZone:zone] autorelease];
            object.accountType = [[self.accountType copyWithZone:zone] autorelease];
            object.activeDirectoryAccountMail = [[self.activeDirectoryAccountMail copyWithZone:zone] autorelease];
            object.activeDirectoryBaseDn = [[self.activeDirectoryBaseDn copyWithZone:zone] autorelease];
            object.activeDirectoryServer = [[self.activeDirectoryServer copyWithZone:zone] autorelease];
            object.boss = [[self.boss copyWithZone:zone] autorelease];
            object.createDate = [[self.createDate copyWithZone:zone] autorelease];
            object.email = [[self.email copyWithZone:zone] autorelease];
            object.exportAbility = self.exportAbility;
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.inheritanceStatus = [[self.inheritanceStatus copyWithZone:zone] autorelease];
            object.name = [[self.name copyWithZone:zone] autorelease];
            object.printAbility = self.printAbility;
            object.role = [[self.role copyWithZone:zone] autorelease];
            object.secretary = self.secretary;
            object.status = [[self.status copyWithZone:zone] autorelease];
            
            object.companyGuid = [[self.companyGuid copyWithZone:zone] autorelease];
            object.lastPasswordChangeTime = [[self.lastPasswordChangeTime copyWithZone:zone] autorelease];
            object.lockedIssue = [[self.lockedIssue copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountSubscriptionStatus":@"accountSubscriptionStatus",
                                                              @"accountType":@"accountType",
                                                              @"activeDirectoryAccountMail":@"activeDirectoryAccountMail",           @"activeDirectoryBaseDn":@"activeDirectoryBaseDn",
                                                              @"activeDirectoryServer":@"activeDirectoryServer",
                                                              @"boss":@"boss",
                                                              @"createDate" : @"createDate",
                                                              @"email" : @"email",
                                                              @"exportAbility" : @"exportAbility",
                                                              @"guid" : @"guid",
                                                              @"inheritanceStatus":@"inheritanceStatus",
                                                              @"name" : @"name",
                                                              @"printAbility" : @"printAbility",
                                                              @"role" : @"role",
                                                              @"secretary" : @"secretary",
                                                              @"status" : @"status",
                                                              @"companyGuid" : @"companyGuid",
                                                              @"lastPasswordChangeTime" : @"lastPasswordChangeTime",
                                                              @"lockedIssue" : @"lockedIssue"}];
    }
    
    return responseMapping;
}
@end
