//
//  WCTRCPageInfo.m
//  
//
//  Created by Howard on 2016/3/23.
//
//

#import "WCTRCPageInfo.h"

@implementation WCTRCPageInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_fieldOrderBy release];
    _fieldOrderBy = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{ascendingOrder:%d, fieldOrderBy:%@, numberPerPage:%td, pageIndex:%td}",
            [super description],
            self.ascendingOrder,
            self.fieldOrderBy,
            self.numberPerPage,
            self.pageIndex];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCPageInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.ascendingOrder = self.ascendingOrder;
            object.fieldOrderBy = [[self.fieldOrderBy copyWithZone:zone] autorelease];
            object.numberPerPage = self.numberPerPage;
            object.pageIndex = self.pageIndex;
        }
    }
    
    return object;
    
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"ascendingOrder":@"ascendingOrder",
                                                              @"fieldOrderBy":@"fieldOrderBy",
                                                              @"numberPerPage":@"numberPerPage",
                                                              @"pageIndex":@"pageIndex"}];
    }
    
    return responseMapping;
}
@end
