//
//  WCTRCContactsSetFavoriteRequest.m
//  
//
//  Created by Howard on 2016/3/23.
//
//

#import "WCTRCContactsSetFavoriteRequest.h"

@implementation WCTRCContactsSetFavoriteRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_accountGuid release];
    _accountGuid = nil;
    
    [_contactGuids release];
    _contactGuids = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{accountGuid:%@, contactGuids:%@, markAsFavorite:%d}",
            [super description],
            self.accountGuid,
            self.contactGuids,
            self.markAsFavorite];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactsSetFavoriteRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.accountGuid = [[self.accountGuid copyWithZone:zone] autorelease];
            object.contactGuids = [[self.contactGuids copyWithZone:zone] autorelease];
            object.markAsFavorite = self.markAsFavorite;
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"accountGuid":@"accountGuid",
                                                              @"contactGuids":@"contactGuids",
                                                              @"markAsFavorite":@"markAsFavorite"}];
    }
    
    return responseMapping;
}
@end
