//
//  WCTRCContactUpdateInfoRequest.m
//  
//
//  Created by Howard on 2016/3/17.
//
//

#import "WCTRCContactUpdateInfoRequest.h"

@implementation WCTRCContactUpdateInfoRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.contactGuid = nil;
    self.categoryOwnerAccountGuid = nil;
    self.belongingCategories = nil;
    self.frontImageFileGuid = nil;
    self.rearImageFileGuid = nil;
    self.logoImageFileGuid = nil;
    self.displayModifyTime = nil;
    
    self.names = nil;
    self.jobinfos = nil;
    self.addresses = nil;
    self.phones = nil;
    self.emails = nil;
    self.urls = nil;
    self.ims = nil;
    self.socials = nil;
    self.dates = nil;
    self.customFields = nil;
    self.birthday = nil;
    self.nickname = nil;
    self.note = nil;
    self.uniformNumber = nil;
    self.updateComponents = nil;
    self.shareToAccountGuids = nil;

    self.syncModifyTime = nil;

    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{contactGuid:%@, categoryOwnerAccountGuid:%@, shareToAccountGuids:%@, belongingCategories:%@, frontImageFileGuid:%@, rearImageFileGuid:%@, logoImageFileGuid:%@, displayModifyTime:%@, recogLanguageFront:%ld, recogLanguageBack:%ld, beCorrected:%@, name:%@, jobinfos:%@, addresses:%@, phones:%@, emails:%@, urls:%@, ims:%@, socials:%@, dates:%@, customFields:%@, birthday:%@, nickname:%@, note:%@, uniformNumber:%@, updateComponents:%@, syncModifyTime:%@}",
            [super description],
            self.contactGuid,
            self.categoryOwnerAccountGuid,
            self.shareToAccountGuids,
            self.belongingCategories,
            self.frontImageFileGuid,
            self.rearImageFileGuid,
            self.logoImageFileGuid,
            self.displayModifyTime,
            (long)self.recogLanguageFront,
            (long)self.recogLanguageBack,
            self.beCorrected?@"YES":@"NO",
            self.names,
            self.jobinfos,
            self.addresses,
            self.phones,
            self.emails,
            self.urls,
            self.ims,
            self.socials,
            self.dates,
            self.customFields,
            self.birthday,
            self.nickname,
            self.note,
            self.uniformNumber,
            self.updateComponents,
            self.syncModifyTime];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactUpdateInfoRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.contactGuid = [[self.contactGuid copyWithZone:zone] autorelease];
            object.categoryOwnerAccountGuid = [[self.categoryOwnerAccountGuid copyWithZone:zone] autorelease];
            object.shareToAccountGuids = [[self.shareToAccountGuids copyWithZone:zone] autorelease];
            object.belongingCategories = [[self.belongingCategories copyWithZone:zone] autorelease];
            object.frontImageFileGuid = [[self.frontImageFileGuid copyWithZone:zone] autorelease];
            object.rearImageFileGuid = [[self.rearImageFileGuid copyWithZone:zone] autorelease];
            object.logoImageFileGuid = [[self.logoImageFileGuid copyWithZone:zone] autorelease];
            object.displayModifyTime = [[self.displayModifyTime copyWithZone:zone] autorelease];

            object.recogLanguageFront = self.recogLanguageFront;
            object.recogLanguageBack = self.recogLanguageBack;
            object.beCorrected = self.beCorrected;

            object.names = [[self.contactGuid copyWithZone:zone] autorelease];
            object.jobinfos = [[self.jobinfos copyWithZone:zone] autorelease];
            object.addresses = [[self.addresses copyWithZone:zone] autorelease];
            object.phones = [[self.phones copyWithZone:zone] autorelease];
            object.emails = [[self.emails copyWithZone:zone] autorelease];
            object.urls = [[self.urls copyWithZone:zone] autorelease];
            object.ims = [[self.ims copyWithZone:zone] autorelease];
            object.socials = [[self.socials copyWithZone:zone] autorelease];
            object.customFields = [[self.customFields copyWithZone:zone] autorelease];
            object.dates = [[self.dates copyWithZone:zone] autorelease];
            object.birthday = [[self.birthday copyWithZone:zone] autorelease];
            object.nickname = [[self.nickname copyWithZone:zone] autorelease];
            object.note = [[self.note copyWithZone:zone] autorelease];
            object.uniformNumber = [[self.uniformNumber copyWithZone:zone] autorelease];
            object.updateComponents = [[self.updateComponents copyWithZone:zone] autorelease];
            
            object.syncModifyTime = [[self.syncModifyTime copyWithZone:zone] autorelease];

        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"contactGuid":@"contactGuid",
                                                              @"categoryOwnerAccountGuid":@"categoryOwnerAccountGuid",
                                                              @"shareToAccountGuids":@"shareToAccountGuids",
                                                              @"frontImageFileGuid":@"frontImageFileGuid",
                                                              @"rearImageFileGuid":@"rearImageFileGuid",
                                                              @"logoImageFileGuid":@"logoImageFileGuid",
                                                              @"displayModifyTime":@"displayModifyTime",
                                                              @"syncModifyTime":@"syncModifyTime",
                                                              @"recogLanguageFront":@"recogLanguageFront",
                                                              @"recogLanguageBack":@"recogLanguageBack",
                                                              @"beCorrected":@"beCorrected",
                                                              @"birthday":@"birthday",
                                                              @"nickname":@"nickname",
                                                              @"note":@"note",
                                                              @"uniformNumber":@"uniformNumber",
                                                              @"updateComponents":@"updateComponents"}];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"belongingCategories"
                                                                                        toKeyPath:@"belongingCategories"
                                                                                      withMapping:[WCTRCSimpleCategoryInfo responseMapping]]];

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"names"
                                                                                        toKeyPath:@"names"
                                                                                      withMapping:[WCTRCContactNameInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"jobinfos"
                                                                                        toKeyPath:@"jobinfos"
                                                                                      withMapping:[WCTRCContactJobInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"addresses"
                                                                                        toKeyPath:@"addresses"
                                                                                      withMapping:[WCTRCContactAddressInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"phones"
                                                                                        toKeyPath:@"phones"
                                                                                      withMapping:[WCTRCContactPhoneInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"emails"
                                                                                        toKeyPath:@"emails"
                                                                                      withMapping:[WCTRCContactMailInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"urls"
                                                                                        toKeyPath:@"urls"
                                                                                      withMapping:[WCTRCContactUrlInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"ims"
                                                                                        toKeyPath:@"ims"
                                                                                      withMapping:[WCTRCContactIMInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"socials"
                                                                                        toKeyPath:@"socials"
                                                                                      withMapping:[WCTRCContactSocialInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"customDataList"
                                                                                        toKeyPath:@"customFields"
                                                                                      withMapping:[WCTRCContactCustomFieldData responseMapping]]];

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"dates"
                                                                                        toKeyPath:@"dates"
                                                                                      withMapping:[WCTRCContactDateInfo responseMapping]]];
    }
    
    return responseMapping;
}
@end
