//
//  WCTRCContactSocialInfo.m
//  
//
//  Created by Howard on 2016/5/9.
//
//

#import "WCTRCContactSocialInfo.h"

@implementation WCTRCContactSocialInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.guid = @"";
        self.recognizeSource = @"";
        self.type = @"";
        self.value = @"";
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_guid release];
    _guid = nil;
    
    [_recognizeSource release];
    _recognizeSource = nil;
    
    [_type release];
    _type = nil;
    
    [_value release];
    _value = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{guid:%@, reconizeSource:%@, type:%@, value:%@}",
            [super description],
            self.guid,
            self.recognizeSource,
            self.type,
            self.value];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactSocialInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.recognizeSource = [[self.recognizeSource copyWithZone:zone] autorelease];
            object.type = [[self.type copyWithZone:zone] autorelease];
            object.value = [[self.value copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"guid":@"guid",
                                                              @"recognizeSource":@"recognizeSource",
                                                              @"type":@"type",
                                                              @"value":@"value"}];
    }
    
    return responseMapping;
}
@end
