//
//  WCTRCContactGetByGuidListRequest.m
//  Pods
//
//  Created by sanhue on 2016/10/14.
//
//

#import "WCTRCContactGetByGuidListRequest.h"

@implementation WCTRCContactGetByGuidListRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_list release];
    _list = nil;
    
    [_pageInfo release];
    _pageInfo = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{guidList:%@, pageInfo:%@}",
            [super description],
            self.list,
            self.pageInfo];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactGetByGuidListRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.list = [[self.list copyWithZone:zone] autorelease];
            object.pageInfo = [[self.pageInfo copyWithZone:zone] autorelease];
        }
    }
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"list":@"list"}];
        
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"pageInfo"
                                                                                        toKeyPath:@"pageInfo"
                                                                                      withMapping:[WCTRCPageInfo responseMapping]]];
    }
    
    return responseMapping;
}

@end
