//
//  WCTRCContactGetByCategoryRequest.m
//  
//
//  Created by Howard on 2016/3/23.
//
//

#import "WCTRCContactGetByCategoryRequest.h"

@implementation WCTRCContactGetByCategoryRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_categoryGuid release];
    _categoryGuid = nil;
    
    [_pageInfo release];
    _pageInfo = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{categoryGuid:%@, pageInfo:%@, enablePcsFilter:%@}",
            [super description],
            self.categoryGuid,
            self.pageInfo,
            self.enablePcsFilter?@"YES":@"NO"];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactGetByCategoryRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.categoryGuid = [[self.categoryGuid copyWithZone:zone] autorelease];
            object.pageInfo = [[self.pageInfo copyWithZone:zone] autorelease];
            object.enablePcsFilter = self.enablePcsFilter;
        }
    }
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"categoryGuid":@"categoryGuid",
                                                              @"enablePcsFilter":@"enablePcsFilter"
        }];
    
        //////////////////////////////////////////////////
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"pageInfo"
                                                                                        toKeyPath:@"pageInfo"
                                                                                      withMapping:[WCTRCPageInfo responseMapping]]];
    }
    
    return responseMapping;
}
@end
