//
//  WCTRCContactCustomFieldInfo.m
//  Pods
//
//  Created by sanhue on 2016/10/26.
//
//

#import "WCTRCContactCustomFieldData.h"

@implementation WCTRCContactCustomFieldData

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_customFieldSettingGuid release];
    _customFieldSettingGuid = nil;
    
    [_fieldType release];
    _fieldType = nil;
    
    [_guid release];
    _guid = nil;
    
    [_textValue release];
    _textValue = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{customFieldSettingGuid:%@, fieldType:%@, guid:%@, textValue:%@}",
            [super description],
            self.customFieldSettingGuid,
            self.fieldType,
            self.guid,
            self.textValue];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactCustomFieldData *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.customFieldSettingGuid = [[self.customFieldSettingGuid copyWithZone:zone] autorelease];
            object.fieldType = [[self.fieldType copyWithZone:zone] autorelease];
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.textValue = [[self.textValue copyWithZone:zone] autorelease];
        }
    }
    
    return object;
    
    
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"customfieldSettingGuid":@"customFieldSettingGuid",
                                                              @"fieldType":@"fieldType",
                                                              @"guid":@"guid",
                                                              @"textValue":@"textValue"}];
    }
    
    return responseMapping;
}

@end
