//
//  WCTRCContactCreationWithImageRequest.m
//  
//
//  Created by Howard on 2016/3/17.
//
//

#import "WCTRCContactCreationWithImageRequest.h"

@implementation WCTRCContactCreationWithImageRequest

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_addresses release];
    _addresses = nil;
    
    [_belongingCategories release];
    _belongingCategories = nil;
    
    [_belongingCategoriesOwnerAccountGuid release];
    _belongingCategoriesOwnerAccountGuid = nil;
    
    [_birthday release];
    _birthday = nil;
    
    [_clientCreatedContactGuid release];
    _clientCreatedContactGuid = nil;
    
    [_clientCreatedTime release];
    _clientCreatedTime = nil;

    [_displayModifyTime release];
    _displayModifyTime = nil;

    [_creatorAccountGuid release];
    _creatorAccountGuid = nil;

    [_customFields release];
    _customFields = nil;
    
    [_dates release];
    _dates = nil;
    
    [_emails release];
    _emails = nil;
    
    [_exportedCrmAccount release];
    _exportedCrmAccount = nil;
    
    [_exportedCrmRecordID release];
    _exportedCrmRecordID = nil;
    
    [_exportedCrmTargetType release];
    _exportedCrmTargetType = nil;
    
    [_frontImageFileGuid release];
    _frontImageFileGuid = nil;
    
    [_ims release];
    _ims = nil;
    
    [_jobinfos release];
    _jobinfos = nil;
    
    [_logoImageFileGuid release];
    _logoImageFileGuid = nil;
    
    [_names release];
    _names = nil;
    
    [_nickname release];
    _nickname = nil;
    
    [_note release];
    _note = nil;
    
    [_ownerAccountGuid release];
    _ownerAccountGuid = nil;
    
    [_phones release];
    _phones = nil;
    
    [_rearImageFileGuid release];
    _rearImageFileGuid = nil;
    
    [_shareToAccountGuids release];
    _shareToAccountGuids = nil;

    [_socials release];
    _socials = nil;

    [_uniformNumber release];
    _uniformNumber = nil;
    
    [_urls release];
    _urls = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{addresses:%@, belongingCategories:%@, belongingCategoriesOwnerAccountGuid:%@, birthday:%@, clientCreatedContactGuid:%@, clientCreatedTime:%@, displayModifyTime:%@, creatorAccountGuid:%@, customFields:%@, dates:%@, emails:%@, exportedCrmAccount:%@, exportedCrmRecordID:%@, exportedCrmTargetType:%@, frontImageFileGuid:%@, ims:%@, beCorrected:%d, jobinfos:%@, logoImageFileGuid:%@, names:%@, nickname:%@, note:%@, ownerAccountGuid:%@ phones:%@, rearImageFileGuid:%@, recogLanguageBack:%td, recogLanguageFront:%td, shareToAccountGuids:%@, socials:%@, uniformNumber:%@, urls:%@",
            [super description],
            self.addresses,
            self.belongingCategories,
            self.belongingCategoriesOwnerAccountGuid,
            self.birthday,
            self.clientCreatedContactGuid,
            self.clientCreatedTime,
            self.displayModifyTime,
            self.creatorAccountGuid,
            self.customFields,
            self.dates,
            self.emails,
            self.exportedCrmAccount,
            self.exportedCrmRecordID,
            self.exportedCrmTargetType,
            self.frontImageFileGuid,
            self.ims,
            self.beCorrected,
            self.jobinfos,
            self.logoImageFileGuid,
            self.names,
            self.nickname,
            self.note,
            self.ownerAccountGuid,
            self.phones,
            self.rearImageFileGuid,
            self.recogLanguageBack,
            self.recogLanguageFront,
            self.shareToAccountGuids,
            self.socials,
            self.uniformNumber,
            self.urls];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactCreationWithImageRequest *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.addresses = [[self.addresses copyWithZone:zone] autorelease];
            object.belongingCategories = [[self.belongingCategories copyWithZone:zone] autorelease];
            object.belongingCategoriesOwnerAccountGuid = [[self.belongingCategoriesOwnerAccountGuid copyWithZone:zone] autorelease];
            object.birthday = [[self.birthday copyWithZone:zone] autorelease];
            object.clientCreatedContactGuid = [[self.clientCreatedContactGuid copyWithZone:zone] autorelease];
            object.clientCreatedTime = [[self.clientCreatedTime copyWithZone:zone] autorelease];
            object.displayModifyTime = [[self.displayModifyTime copyWithZone:zone] autorelease];
            object.creatorAccountGuid = [[self.creatorAccountGuid copyWithZone:zone] autorelease];
            object.customFields = [[self.customFields copyWithZone:zone] autorelease];
            object.dates = [[self.dates copyWithZone:zone] autorelease];
            object.emails = [[self.emails copyWithZone:zone] autorelease];
            object.exportedCrmAccount = [[self.exportedCrmAccount copyWithZone:zone] autorelease];
            object.exportedCrmRecordID = [[self.exportedCrmRecordID copyWithZone:zone] autorelease];
            object.exportedCrmTargetType = [[self.exportedCrmTargetType copyWithZone:zone] autorelease];
            object.frontImageFileGuid = [[self.frontImageFileGuid copyWithZone:zone] autorelease];
            object.ims = [[self.ims copyWithZone:zone] autorelease];
            object.beCorrected = self.beCorrected;
            object.jobinfos = [[self.jobinfos copyWithZone:zone] autorelease];
            object.logoImageFileGuid = [[self.logoImageFileGuid copyWithZone:zone] autorelease];
            object.names = [[self.names copyWithZone:zone] autorelease];
            object.nickname = [[self.nickname copyWithZone:zone] autorelease];
            object.note = [[self.note copyWithZone:zone] autorelease];
            object.ownerAccountGuid = [[self.ownerAccountGuid copyWithZone:zone] autorelease];
            object.phones = [[self.phones copyWithZone:zone] autorelease];
            object.rearImageFileGuid = [[self.rearImageFileGuid copyWithZone:zone] autorelease];
            object.recogLanguageBack = self.recogLanguageBack;
            object.recogLanguageFront = self.recogLanguageFront;
            object.shareToAccountGuids = [[self.shareToAccountGuids copyWithZone:zone] autorelease];
            object.socials = [[self.socials copyWithZone:zone] autorelease];
            object.uniformNumber = [[self.uniformNumber copyWithZone:zone] autorelease];
            object.urls = [[self.urls copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];

    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"birthday":@"birthday",
                                                              @"clientCreatedContactGuid":@"clientCreatedContactGuid",
                                                              @"belongingCategoriesOwnerAccountGuid":@"belongingCategoriesOwnerAccountGuid",
                                                              @"clientCreatedTime":@"clientCreatedTime",
                                                              @"displayModifyTime":@"displayModifyTime",
                                                              @"creatorAccountGuid":@"creatorAccountGuid",
                                                              @"exportedCrmAccount":@"exportedCrmAccount",
                                                              @"exportedCrmRecordID":@"exportedCrmRecordID",
                                                              @"exportedCrmTargetType":@"exportedCrmTargetType",
                                                              @"frontImageFileGuid":@"frontImageFileGuid",
                                                              @"logoImageFileGuid":@"logoImageFileGuid",
                                                              @"beCorrected":@"beCorrected",
                                                              @"nickname":@"nickname",
                                                              @"note":@"note",
                                                              @"ownerAccountGuid":@"ownerAccountGuid",
                                                              @"rearImageFileGuid":@"rearImageFileGuid",
                                                              @"recogLanguageBack":@"recogLanguageBack",
                                                              @"recogLanguageFront":@"recogLanguageFront",
                                                              @"shareToAccountGuids":@"shareToAccountGuids",
                                                              @"uniformNumber":@"uniformNumber"}];
        
        //////////////////////////////////////////////////
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"belongingCategories"
                                                                                        toKeyPath:@"belongingCategories"
                                                                                      withMapping:[WCTRCSimpleCategoryInfo responseMapping]]];

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"addresses"
                                                                                        toKeyPath:@"addresses"
                                                                                      withMapping:[WCTRCContactAddressInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"customDataList"
                                                                                        toKeyPath:@"customFields"
                                                                                      withMapping:[WCTRCContactCustomFieldData responseMapping]]];

        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"dates"
                                                                                        toKeyPath:@"dates"
                                                                                      withMapping:[WCTRCContactDateInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"emails"
                                                                                        toKeyPath:@"emails"
                                                                                      withMapping:[WCTRCContactMailInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"ims"
                                                                                        toKeyPath:@"ims"
                                                                                      withMapping:[WCTRCContactIMInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"jobinfos"
                                                                                        toKeyPath:@"jobinfos"
                                                                                      withMapping:[WCTRCContactJobInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"names"
                                                                                        toKeyPath:@"names"
                                                                                      withMapping:[WCTRCContactNameInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"phones"
                                                                                        toKeyPath:@"phones"
                                                                                      withMapping:[WCTRCContactPhoneInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"socials"
                                                                                        toKeyPath:@"socials"
                                                                                      withMapping:[WCTRCContactSocialInfo responseMapping]]];
        
        [responseMapping addPropertyMapping:[RKRelationshipMapping relationshipMappingFromKeyPath:@"urls"
                                                                                        toKeyPath:@"urls"
                                                                                      withMapping:[WCTRCContactUrlInfo responseMapping]]];
    }
    
    return responseMapping;
}

@end
