//
//  WCTRCContactAddressInfo.m
//  
//
//  Created by Howard on 2016/3/17.
//
//

#import "WCTRCContactAddressInfo.h"

@implementation WCTRCContactAddressInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        self.city = @"";
        self.countryCode = @"";
        self.countryName = @"";
        self.guid = @"";
        self.recognizeSource = @"";
        self.state = @"";
        self.street = @"";
        self.type = @"";
        self.zip = @"";
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_city release];
    _city = nil;
    
    [_countryCode release];
    _countryCode = nil;
    
    [_countryName release];
    _countryName = nil;

    [_guid release];
    _guid = nil;

    [_recognizeSource release];
    _recognizeSource = nil;
    
    [_state release];
    _state = nil;
    
    [_street release];
    _street = nil;
    
    [_type release];
    _type = nil;
    
    [_zip release];
    _zip = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{guid:%@, addressFormat:%td, city:%@, countryCode:%@, countryName:%@, recognizeSource:%@, state:%@, street:%@, type:%@, zip:%@}",
            [super description],
            self.guid,
            self.addressFormat,
            self.city,
            self.countryCode,
            self.countryName,
            self.recognizeSource,
            self.state,
            self.street,
            self.type,
            self.zip];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCContactAddressInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.addressFormat = self.addressFormat;
            object.city = [[self.city copyWithZone:zone] autorelease];
            object.countryCode = [[self.countryCode copyWithZone:zone] autorelease];
            object.countryName = [[self.countryName copyWithZone:zone] autorelease];
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.recognizeSource = [[self.recognizeSource copyWithZone:zone] autorelease];
            object.state = [[self.state copyWithZone:zone] autorelease];
            object.street = [[self.street copyWithZone:zone] autorelease];
            object.type = [[self.type copyWithZone:zone] autorelease];
            object.zip = [[self.zip copyWithZone:zone] autorelease];
        }
    }
    
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"addressFormat":@"addressFormat",
                                                              @"city":@"city",
                                                              @"countryCode":@"countryCode",
                                                              @"countryName":@"countryName",
                                                              @"guid":@"guid",
                                                              @"recognizeSource":@"recognizeSource",
                                                              @"state":@"state",
                                                              @"street":@"street",
                                                              @"type":@"type",
                                                              @"zip":@"zip",}];
    }
    
    return responseMapping;
}
@end
