//
//  WCTRCCategoryInfo.m
//  
//
//  Created by Howard on 2016/3/15.
//
//

#import "WCTRCCategoryInfo.h"

@implementation WCTRCCategoryInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_categoryType release];
    _categoryType = nil;
    
    [_guid release];
    _guid = nil;
    
    [_name release];
    _name = nil;
    
    [_updateTime release];
    _updateTime = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
    return [NSString stringWithFormat:@"%@{categoryType:%@, guid:%@, name:%@, updateTime:%@}",
            [super description],
            self.categoryType,
            self.guid,
            self.name,
            self.updateTime];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Methods

//================================================================================
//
//================================================================================
- (id)copyWithZone:(NSZone *)zone
{
    WCTRCCategoryInfo *object = [super copyWithZone:zone];
    
    if(object!=nil)
    {
        @autoreleasepool
        {
            object.categoryType = [[self.categoryType copyWithZone:zone] autorelease];
            object.guid = [[self.guid copyWithZone:zone] autorelease];
            object.name = [[self.name copyWithZone:zone] autorelease];
            object.updateTime = [[self.updateTime copyWithZone:zone] autorelease];
        }
    }
    return object;
}


//================================================================================
//
//================================================================================
+ (RKObjectMapping *)responseMapping
{
    RKObjectMapping *responseMapping = [super responseMapping];
    
    if(responseMapping!=nil)
    {
        [responseMapping addAttributeMappingsFromDictionary:@{@"categoryType":@"categoryType",
                                                              @"guid":@"guid",
                                                              @"name":@"name",
                                                              @"updateTime":@"updateTime"}];
    }
    
    return responseMapping;
}
@end
